<?php

use App\Models\Country;
use App\Models\Setting;
use \Illuminate\Support\Facades\Storage;
use Illuminate\Support\Str;

if (!function_exists('settings')) {
    function settings($key) {
         cache()->remember('settings', 60*60*24, function () {
           return new Setting();
        });

         return cache()->get('settings')->where('key', $key)->with('translations')->get();
    }
}

if (!function_exists('slug')) {
    function slug($string, $separator = '-') {
        if (is_null($string)) {
            return "";
        }

        // Remove spaces from the beginning and from the end of the string
        $string = trim($string);

        // Lower case everything
        // using mb_strtolower() function is important for non-Latin UTF-8 string | more info: https://www.php.net/manual/en/function.mb-strtolower.php
        $string = mb_strtolower($string, "UTF-8");;

        // Make alphanumeric (removes all other characters)
        // this makes the string safe especially when used as a part of a URL
        // this keeps latin characters and arabic charactrs as well
        $string = preg_replace("/[^a-z0-9_\s\-ءاأإآؤئبتثجحخدذرزسشصضطظعغفقكلمنهويةى]#u/", "", $string);

        // Remove multiple dashes or whitespaces
        $string = preg_replace("/[\s-]+/", " ", $string);

        // Convert whitespaces and underscore to the given separator
        $string = preg_replace("/[\s_]/", $separator, $string);

        return $string;
    }
}

/**
 * Custom response code, message and data
 * @param array $options => ['image', 'folderName', 'watermark', 'modelType', 'modelId']
 */
if (!function_exists('storeImage')) {
    function storeImage($options) {
        $image = $options['value'];

        if (isset($options['base64']) && $options['base64'] == true) {
            $extension = explode('/', explode(':', substr($image, 0, strpos($image, ';')))[1])[1];

            $replace = substr($image, 0, strpos($image, ',')+1);

            $image = str_replace($replace, '', $image);

            $image = base64_decode(str_replace(' ', '+', $image));

            $hubFile = [
                'bucket_name'   => $options['folderName'],
                'extension'     => $extension,
                'getMimeType'   => 'image/'.$extension,
            ];
        }

        $image = \Intervention\Image\Facades\Image::make($image)
            ->resize(1024, 683)
            ->encode('webp', 90);

        if (isset($options['watermark'])) {
            $image->insert('logo-sm.png', 'top-right', 10, 10);
        }

        $filename = time().substr(str_shuffle("0123456789abcdefghijklmnopqrstvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ"), 0, 5).'.webp';

        Storage::put('public/'.$options['folderName'].'/'.$filename, $image);

        if ($options['saveInDatabase'] == true) {
            if (!isset($options['base64'])){
                $hubFile = [
                    'bucket_name'   => $options['folderName'],
                    'original_name' => $options['value']->getClientOriginalName(),
                    'extension'     => $options['value']->extension(),
                    'size'          => $options['value']->getSize(),
                    'getMimeType'   => $options['value']->getMimeType(),
                ];
            }

          $options['model']->hubFiles()->updateOrCreate($hubFile + ['path' => $filename]);
        }
    }
}

if (!function_exists('getImage')) {
    function getImage($value) {
        if($value){
            return asset('storage/' . $value);
        }
    }
}

if (!function_exists('deleteImage')) {
    function deleteImage($path, $record) {
        Storage::disk('public')->delete($path);

        $record->delete();
    }
}

if (!function_exists('defaultAdminImage')) {
    function defaultAdminImage() {
        return '/admin_main/images/user-dummy-img.jpg';
    }
}

if (!function_exists('defaultStoreImage')) {
    function defaultStoreImage() {
        return '/admin_main/images/store-dummy-img.png';
    }
}

/**
 * Custom response code, message and data
 * @param array $options => ['video', 'folderName', 'modelType', 'modelId']
 */
if (!function_exists('storeVideo')) {
    function storeVideo($options) {
        if($options['value']){

            $filename = time().substr(str_shuffle("0123456789abcdefghijklmnopqrstvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ"), 0, 5).'.mp4';

            Storage::putFileAs('public/'.$options['folderName'], $options['value'], $filename);

            $options['model']->hubFiles()->updateOrCreate([
                'bucket_name'   => $options['folderName'],
                'original_name' => $options['value']->getClientOriginalName(),
                'path'          => $filename,
                'extension'     => $options['value']->extension(),
                'size'          => $options['value']->getSize(),
                'getMimeType'   => $options['value']->getMimeType(),
                'cover'         => isset($options['cover']) ? $options['cover'] : null,
            ]);
        }
    }
}

/**
 * Method a query to convert number
 * @return array
 */
if (!function_exists('convert')) {
    function convertNumberOverThousand($value) {
        if ($value >= 1000) {
            return round($value/1000, 1) . "k";
        } else {
            return $value;
        }
    }
}

/**
 * Method a query to only get users statistics
 * @return array
 */
if (!function_exists('getStatistics')) {
    function getStatistics():array {
        $usersWeek = \App\Models\User::getUsersStatistics( 'week')->pluck('countID', 'week');
        $usersMonth = \App\Models\User::getUsersStatistics('month')->pluck('countID', 'month');
        $usersYear = \App\Models\User::getUsersStatistics( 'year')->pluck('countID', 'year');

        return [
            'usersWeek'     => $usersWeek,
            'usersMonth'    => $usersMonth,
            'usersYear'     => $usersYear,
        ];
    }
}
if (!function_exists('getVisIpAddr')) {

    function getVisIpAddr() {

        if (!empty($_SERVER['HTTP_CLIENT_IP'])) {
            return $_SERVER['HTTP_CLIENT_IP'];
        }
        else if (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {
            return $_SERVER['HTTP_X_FORWARDED_FOR'];
        }
        else {
            return $_SERVER['REMOTE_ADDR'];
        }
    }
}


if (!function_exists('ipCountry')) {
    function ipCountry($ip = NULL, $purpose = "location", $deep_detect = TRUE) {
        $vis_ip = getVisIPAddr();
        $ipdat = @json_decode(file_get_contents("https://api.ipgeolocation.io/ipgeo?apiKey=5bb40ee909f342e5973fa4f59ab1290e&ip=" . $vis_ip));

        return \App\Models\Country::where('iso_code',$ipdat->country_code2)->where('parent_id',null)->first();

    }
    if (!function_exists('defaultMoonImage')) {
        function defaultMoonImage() {
            return getImage(settings(\App\Helpers\Constant::SETTING_KEYS['Logo'])->first()->image);
        }
    }

}
