<?php

namespace App\Http\Controllers\Api\V100\Advertisement;

use App\Helpers\Constant;
use App\Http\Controllers\Controller;
use App\Http\Requests\Api\V100\GetFilterRequest;
use App\Models\Advertisement;
use App\Services\RespondActive;

class GetFilterResults extends Controller
{
    public function __invoke(GetFilterRequest $request)
    {
        $advertisements = Advertisement::query()
            ->when($request->sub_category_id, function ($query) use ($request) {
                $query->where('sub_category_id', $request->sub_cateogry_id);
            })
            ->when($request->properties, function ($query) use ($request) {
                $query->whenHas('properties', function ($query) use ($request) {
                   foreach ($request->properties as $property) {
                       $query->where('id', $property['id'])
                           ->whereBettwen('pivot.text', [$property['from'], $property['to']]);
                   }
                });
            })
            ->when($request->country_id, function ($query) use ($request) {
                $query->where('city.country', $request->country_id);
            })
            ->when($request->city_ids, function ($query) use ($request) {
                $query->whereIn('city', $request->city_ids);
            })
            ->when($request->max_price && $request->min_price, function ($query) use ($request) {
                $query->where('price', '>=', $request->min_price )->where('price', '<=', $request->max_price );
            })
            ->when($request->order_by == Constant::FILTER_ORDER_BY['Newest'], function ($query) use ($request) {
                $query->orderBy('id', 'desc');
            })
            ->when($request->order_by == Constant::FILTER_ORDER_BY['Least price'], function ($query) use ($request) {
                $query->orderBy('price', 'asc');
            })
            ->when($request->order_by == Constant::FILTER_ORDER_BY['Highest price'], function ($query) use ($request) {
                $query->orderBy('price', 'desc');
            })
            ->when($request->advertisement_type == Constant::FILTER_ADVERTISEMENT_TYPE['Premium'], function ($query) use ($request) {
                $query->where('premium', Constant::PREMIUM_STATUS['True']);
            })
            ->when($request->advertisement_type == Constant::FILTER_ADVERTISEMENT_TYPE['Free'], function ($query) use ($request) {
                $query->where('premium', Constant::PREMIUM_STATUS['False']);
            })
//            ->when($request->rates, function ($query) use ($request) {
//                $query->where('average_rate', $request->country_id);
//            })
            ->paginate();

        return RespondActive::success('The action ran successfully!', $advertisements);
    }
}
