<?php

namespace App\Http\Controllers\Api\V100;

use App\Http\Controllers\Controller;
use App\Http\Requests\Api\V100\GetSubCategoryRequest;
use App\Http\Resources\Category\CategoryResource;
use App\Http\Resources\Category\SubCategoryCollection;
use App\Models\Category;
use App\Services\RespondActive;
use App\Services\User\StoreService;

class CategoryController extends Controller
{
    public function index()
    {
        $data = CategoryResource::collection(
            Category::with('subCategories.translation', 'translation')
                ->getActiveCategories()
                ->search(request()->search)
                ->get()
        );

        return RespondActive::success('The action ran successfully!', $data);
    }

    public function subCategories(GetSubCategoryRequest $request)
    {
        $data = new SubCategoryCollection(
            StoreService::storesBasedOnParameters([
                'category_id'   => $request->category_id,
                'limit'         => 5
            ])
        );

        return RespondActive::success('The action ran successfully!', $data);
    }
}
