<?php

namespace App\Http\Controllers\Api\V100\Follow;

use App\Http\Controllers\Controller;
use App\Http\Requests\Api\V100\Follow\FollowRequest;
use App\Services\RespondActive;

class StoreFollower extends Controller
{
    public function __invoke(FollowRequest $request)
    {
        if( auth()->user()->followings()->exists($request->store_id) ) {

            auth()->user()->followings()->detach($request->store_id);
        }else {

            auth()->user()->followings()->attach($request->store_id);
        }

        return RespondActive::success('The action ran successfully!');
    }
}
