<?php

namespace App\Http\Controllers\Api\V100\Map;

use App\Helpers\Constant;
use App\Http\Controllers\Controller;
use App\Http\Requests\Api\V100\Map\GetMapDetailsRequest;
use App\Http\Resources\Advertisement\AdvertisementResource;
use App\Http\Resources\User\StoreResource;
use App\Models\Advertisement;
use App\Models\User;
use App\Services\RespondActive;

class GetMapDetails extends Controller
{
    public function __invoke(GetMapDetailsRequest $request)
    {
        switch ($request->type) {
            case 'store':
                $data = StoreResource::collection(
                    User::getVerifiedUserBasedOnTypeAndCountry(Constant::USER_TYPE['Store'], $request->header('countryId'))
                    ->with('categories')
                    ->latest('id')
                    ->take(100)
                    ->get()
                );
                break;
            case 'advertisement':
                $data = AdvertisementResource::collection(
                    Advertisement::getAdvertisementBasedOnCountry($request->header('countryId'))
                    ->with('subCategory.category')
                    ->latest('id')
                    ->take(100)
                    ->get()
                );
        }

        return RespondActive::success('The action ran successfully!', $data);
    }
}
