<?php

namespace App\Http\Controllers\Api\V100\Profile;

use App\Helpers\Constant;
use App\Http\Controllers\Controller;
use App\Http\Requests\Api\V100\Advertisement\GetAdvertisementDetailsRequest;
use App\Http\Requests\Api\V100\Profile\GetProfileAdvertisementsRequest;
use App\Http\Requests\Api\V100\Profile\UpdateUserProfileRequest;
use App\Http\Resources\Advertisement\AdvertisementResource;
use App\Http\Resources\User\StoreResource;
use App\Http\Resources\User\UserResource;
use App\Services\Advertisement\AdvertisementService;
use App\Services\RespondActive;

class ProfileController extends Controller
{
    public function update(UpdateUserProfileRequest $request)
    {
        auth()->user()->update($request->validated());

        if ($request->image) {
            if (auth()->user()->hubFiles()->exists()) {
                deleteImage(auth()->user()->hubFiles->get_folder_file(), auth()->user()->hubFiles());
            }

            storeImage([
                'value'             => $request->image,
                'folderName'        => Constant::USER_IMAGE_FOLDER_NAME,
                'model'             => auth()->user(),
                'saveInDatabase'    => true
            ]);
        }

        auth()->user()['token'] = auth()->user()->createToken('token'.auth()->id())->plainTextToken;

        return RespondActive::success('The action ran successfully!', new UserResource(auth()->user()));
    }

    public function followings()
    {
        $followings = StoreResource::collection(
            auth()->user()->followings()->paginate()
        )->response()->getData();

        return RespondActive::success('The action ran successfully!', $followings);
    }

    public function advertisements(GetProfileAdvertisementsRequest $request)
    {
        $advertisements = AdvertisementResource::collection(
            AdvertisementService::advertisementsBasedOnParameters([
                'usersActionsType'  => $request->type,
                'limit'             => 15,
                'paginate'          => true
            ])
        )->response()->getData();

        return RespondActive::success('The action ran successfully!', $advertisements);
    }

    public function blocked()
    {
        $stores = StoreResource::collection(
            auth()->user()->storesByType(Constant::USER_STORE_TYPE['Block'])->get()
        );

        return RespondActive::success('The action ran successfully!', $stores);
    }
}
