<?php

namespace App\Http\Controllers\Api\V100;

use App\Http\Controllers\Controller;
use App\Http\Requests\Api\V100\Auth\SetFirebaseTokenRequest;
use App\Models\PersonalFirebaseToken;
use App\Services\RespondActive;

class SetFirebaseToken extends Controller
{
    public function __invoke(SetFirebaseTokenRequest $request)
    {
        auth()->user()->update([ 'platform' => $request->platform ]);

        PersonalFirebaseToken::updateOrCreate(
            [
                'user_id'           => auth()->id(),
                'device_id'         => $request->device_id
            ],
            [
                'firebase_token'    => $request->firebase_token
            ]
        );

        return RespondActive::success('The action ran successfully!');
    }
}
