<?php

namespace App\Http\Controllers\Api\V100\Story;

use App\Helpers\Constant;
use App\Http\Controllers\Controller;
use App\Http\Requests\Api\V100\Story\SetStorySeenRequest;
use App\Http\Resources\User\StoreResource;
use App\Models\User;
use App\Services\RespondActive;

class StoryController extends Controller
{
    public function index()
    {
        $stories = StoreResource::collection(
            User::getVerifiedUserBasedOnType(Constant::USER_TYPE['Store'])
            ->with('stories')
            ->whereHas('stories')
            ->get()
        );

        return RespondActive::success('The action ran successfully!', $stories);
    }

    public function seen(SetStorySeenRequest $request)
    {
        auth('sanctum')->user()->storyViews()->attach($request->story_id);

        return RespondActive::success('The action ran successfully!');
    }
}
