<?php

namespace App\Http\Controllers\Website;

use App\Helpers\Constant;
use App\Http\Resources\Explore\ExploreCommentsResource;
use App\Http\Resources\Explore\ExploreResource;
use App\Models\Explore;
use App\Services\RespondActive;
use App\Services\Website\CountryService;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class ExploresController extends Controller
{
    public function index()
    {
        $selectedCountry = CountryService::selectCountry();

        $explores = Explore::orderBy('created_at', 'desc')
            ->whereHas('store', function ($query) use ($selectedCountry) {
                $query->whereHas('city', function ($query) use ($selectedCountry) {
                    $query->where('parent_id', $selectedCountry->id);
                });
            })
            ->with('hubFiles')->get();

        $videoExtensions = ['mp4', 'mov', 'avi'];
//        foreach ($explores as $explore){
//            if(in_array($explore->hubFiles->extension,$videoExtensions))
//            {
//                return $explore;
//            }
//
//        }
//        return 'test';
        return view('Website.pages.explore.view-all-explores', compact(
            'explores', 'videoExtensions'));

    }

    public function show($lang, $id)
    {

        $explore = Explore::whereId($id)->with('hubFiles', 'store')
            ->when(auth()->user(), function ($query) {
                auth()->user()->blockedStores->each(function ($store) use ($query) {
                    $query->whereNotIn('id', $store->explores->pluck('id'));
                });
            })
            ->withCount('likes', 'comments', 'shares')
            ->withCount(['users as is_liked' => function ($query) use ($id) {
                auth()->user() &&
                auth()->user()
                    ->exploreActions(Constant::EXPLORE_USER_TYPE['Like'])
                    ->where('explore_id', $id)
                    ->exists();
            }])
            ->inRandomOrder()
            ->with(['comments'=>function($query){
                $query->with('user');
            }])

            ->first();


//        $explore=Explore::whereId($id)->with(['hubFiles','store'])->first();
        $relatedExplores = Explore::where('store_id', $explore->store_id)
        ->where('id','!=',$id)
            ->with(['hubFiles', 'store'])
            ->withCount('likes', 'comments', 'shares')

            ->withCount(['users as is_liked' => function ($query) use ($id) {
                auth()->user() &&
                auth()->user()
                    ->exploreActions(Constant::EXPLORE_USER_TYPE['Like'])
                    ->where('explore_id', $id)
                    ->exists();
            }])
            ->with(['comments'=> function ($query) {
                $query->with('user');
            }])
            ->get();
        $videoExtensions = ['mp4', 'mov', 'avi'];
        $page = request()->page ? request()->page + 1 : 2;
        return view('Website.pages.explore.explore-details', compact(
            'explore', 'videoExtensions', 'relatedExplores', 'page'));

    }


}
