<?php

namespace App\Http\Controllers\Website;

use App\Helpers\Constant;
use App\Http\Controllers\Controller;
use App\Http\Requests\Website\V100\FilterAdvertisementsRequest;
use App\Http\Requests\Website\V100\FilterShopsRequest;
use App\Models\Advertisement;
use App\Models\Category;
use App\Models\Country;
use App\Models\Package;
use App\Models\Property;
use App\Models\Story;
use App\Models\User;
use App\Services\Website\AdvertisementService;
use App\Services\Website\CountryService;
use App\Services\Website\FilterService;
use Illuminate\Http\Request;

class GetAdvertisementsController extends Controller
{
    public function __invoke(FilterAdvertisementsRequest $request, $lang, $category)
    {
//        dd($request->validated());
        $selectedCountry = CountryService::selectCountry();
        $selectedCategory = Category::whereTranslation('slug', $category)->first();

        $premiumAds = AdvertisementService::advertisement($request, $selectedCountry, $category, $selectedCategory, false, Constant::PREMIUM_STATUS['True'])
            ->count();
        $nonPremiumAds =
            AdvertisementService::advertisement($request, $selectedCountry, $category, $selectedCategory, false, Constant::PREMIUM_STATUS['False'])
                ->count();
        $premiumAdsSlider = AdvertisementService::advertisement($request, $selectedCountry, $category, $selectedCategory, true, Constant::PREMIUM_STATUS['True'])
            ->get();

        $allCities = FilterService::countData(Country::GetActiveCities()->where('parent_id', $selectedCountry->id),$request, $selectedCountry, $category, $selectedCategory)
            ->get();
//        $allCategories=FilterService::countData( Category::getActiveCategories()->withCount(['shops','categoryAdvertisements']),$request, $selectedCountry, $category, $selectedCategory)
//            ->get()
//            ->sortByDesc('category_advertisements_count');

        $rates = AdvertisementService::advertisement($request, $selectedCountry, $category, $selectedCategory)
            ->get()
            ->groupBy('average_rate');

        $properties = FilterService::countData(
            Property::where('parent_id', null)
            ->with(['children' => function ($query) use ($selectedCountry, $category, $request, $selectedCategory) {

              return  FilterService::countData($query,$request,$selectedCountry, $category, $selectedCategory)
                    ;

            }])
            ->whereHas('categories', function ($query) use ($selectedCategory, $request) {
                if ($selectedCategory && $selectedCategory->parent_id != null) {
                    $query->where('category_id', $selectedCategory->category->id)->orWhere('category_id', $selectedCategory->id);

                } elseif ($selectedCategory) {
                    $query->where('category_id', $selectedCategory->id);

                }
                elseif ($request->category_id) {
                    $query->whereIn('category_id', $request->category_id);

                }
                elseif ($request->sub_category_id) {
                    $subCategory=Category::whereId($request->sub_category_id)->first();
                    $query->where('category_id', $subCategory->parent_id);

                }
            })
            ->whereHas('children'),$request, $selectedCountry, $category, $selectedCategory)
            ->get();
//        dd($properties);


        $advertisements =
            AdvertisementService::advertisement($request, $selectedCountry, $category, $selectedCategory)
                ->paginate($request->pages ?? 20);
        $subCategories = FilterService::countData(Category::getActiveSubCategories()
                ->when($category && $category != 'all', function ($query) use ($category) {

                    if (Category::whereTranslation('slug', $category)->first() && Category::whereTranslation('slug', $category)->first()->parent_id != null) {
                        $query->whereTranslation('slug', $category);

                    } else {
                        $query->whereHas('category', function ($query) use ($category) {
                            $query->whereTranslation('slug', $category);
                        });

                    }
                })
                ->when($request->category_id , function ($query) use ($category,$request) {

                        $query->whereIn('parent_id', $request->category_id);
                })

            ,$request, $selectedCountry, $category, $selectedCategory)
            ->get();
        $pageView = $request->view ? $request->view : 4;
        $type = $request->type ? $request->type : 'View';
        $sortBy = $request->sortBy ? $request->sortBy : 'default';
        $pages = $request->pages ? $request->pages : 12;
//return $advertisements->to();
        return view('Website.pages.advertisements.view-all-advertisements',
            compact(
                'allCities', 'rates',
                'properties', 'premiumAds', 'nonPremiumAds',
                'premiumAdsSlider', 'advertisements', 'category'
                , 'pageView', 'type', 'subCategories', 'selectedCategory',
                'sortBy', 'pages'

            ));


    }
}
