<?php

namespace App\Http\Controllers\Website;

use App\Helpers\Constant;
use App\Http\Controllers\Controller;
use App\Models\Advertisement;
use App\Models\Category;
use App\Models\Country;
use App\Models\Package;
use App\Models\Story;
use App\Models\User;
use Illuminate\Http\Request;

class GetCategoriesController extends Controller
{
    public function __invoke()
    {
       $allCategories=Category::getActiveCategories()
           ->withCount('categoryAdvertisements')->with(['subCategories'=>function($query){
           $query->withCount('advertisements');
       }])
           ->whereHas('subCategories',function($query){
        $query->whereHas('advertisements');
    })->with(['subCategories'=>function($query){
           $query->whereHas('advertisements')->withCount('advertisements');
       }])
           ->paginate(8);
       return view('Website.pages.categories.view-all-categories',compact('allCategories'
         ));


    }
}
