<?php

namespace App\Http\Controllers\Website;

use App\Helpers\Constant;
use App\Http\Controllers\Controller;
use App\Http\Resources\User\NotificationResource;
use App\Models\Notification;
use Illuminate\Http\Request;

class GetNotificationsController extends Controller
{
    public function __invoke()
    {
        switch (auth('sanctum')->check()) {
            case true:
                $notifications = auth('sanctum')->user()->notifications()
                    ->where('created_at','>=',auth('sanctum')->user()->created_at)
                    ->where(function ($query){
                    $query->orWhere('all_users', 1);
                });
//                    ->when($request->notify_type == Constant::NOTIFICATION_TYPE['Admin'] ||
//                        $request->notify_type == Constant::NOTIFICATION_TYPE['Store'],
//                        function ($query) use ($request) {
//                            $query->where('notify_type', $request->notify_type);
//                        });

                auth('sanctum')->user()->notifications()->update([ 'seen' => 1 ]);
                break;
            case false:
                $notifications = Notification::where('all_users', 1);
        }

        $notifications = NotificationResource::collection($notifications->latest('id')->paginate())->response()->getData();

        return view('Website.auth.notifications', compact(
            'notifications'));


    }
}
