<?php

namespace App\Http\Controllers\Website;

use App\Helpers\Constant;
use App\Models\Blog;
use App\Models\Package;
use App\Models\Setting;
use App\Services\Website\CountryService;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Http\Response;

class GetPackagesController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return Response
     */
    public function __invoke()
    {
        $selectedCountry=CountryService::selectCountry();
        $sections = Setting::where('key', Constant::SETTING_KEYS['About sections'])->get();

        $packages=Package::active()->where('country_id',$selectedCountry->id)->orderBy('created_at','desc')->get();
        return view('Website.pages.packages.view-all-packages', compact('packages','sections'));

    }
}
