<?php

namespace App\Http\Controllers\Website;

use App\Helpers\Constant;
use App\Http\Controllers\Controller;
use App\Http\Requests\Website\V100\FilterAdvertisementsRequest;
use App\Http\Requests\Website\V100\FilterShopsRequest;
use App\Models\Advertisement;
use App\Models\Category;
use App\Models\Country;
use App\Models\Package;
use App\Models\Property;
use App\Models\Setting;
use App\Models\Story;
use App\Models\User;
use App\Services\Website\CountryService;
use Carbon\Carbon;
use Illuminate\Http\Request;
use function Spatie\Ignition\Config\toArray;

class ShopsController extends Controller
{
    public function index(FilterShopsRequest $request,$lang,$cityName)
    {
//        return $city;
//        $categories = Category::GetActiveCategories()->withCount('shops')->get();
        $selectedCountry=CountryService::selectCountry();

        $cities = Country::GetActiveCities()

            ->where('parent_id',$selectedCountry->id)->withCount('shops')->get();
        $rates = User::CheckUserType(Constant::USER_TYPE['Store'])
            ->whereHas('city',function ($query)use($selectedCountry){
                $query->where('parent_id',$selectedCountry->id);
            })
            ->get()->groupBy('average_rate');
        $premiumAds = Advertisement::premium(Constant::PREMIUM_STATUS['True'])
            ->orderBy('premium', 'desc')
            ->with(['subCategory' => function ($query) {
                $query->with('category');
            }])
            ->whereHas('city',function ($query)use($selectedCountry){
                $query->where('parent_id',$selectedCountry->id);
            })
            ->take(6)
            ->get();
        $shops = User::CheckUserType(Constant::USER_TYPE['Store'])
            ->where('complete_profile',1)

            ->whereHas('city',function ($query)use($selectedCountry){
                $query->where('parent_id',$selectedCountry->id);
            })
            ->orderBy('average_rate')
            ->when($cityName && $cityName!='all',function ($query)use ($cityName){
                $query->whereHas('city', function ($query) use ($cityName) {
                    $query->whereTranslation('slug', $cityName);
                });
            })
            ->when($request->category_id,function ($query)use ($request){
                $query->whereHas('categories',function ($query)use ($request){
                    $query->whereIn('category_store.category_id',$request->category_id);
                });
            })
            ->when($request->city_id,function ($query)use ($request){
                $query->whereIn('city_id',$request->city_id);

            })
            ->when($request->rates,function ($query)use ($request){
                $query->whereIn('average_rate',$request->rates);

            })
            ->withCount('advertisements')
            ->withCount(['followers as is_follow' => function ($query) {
                $query->where('follower_id', auth()->id());
            }])
//            ->when($request->pages, function ($query) use ($request) {
//                $query->take($request->pages);
//            })
            ->when($request->sortBy&&$request->sortBy=='rated', function ($query) use ($request) {
                $query->orderBy('rate_count','desc');
            })
            ->when($request->sortBy&&$request->sortBy=='date', function ($query) use ($request) {
                $query->orderBy('created_at','desc');
            })
            ->when($request->sortBy&&$request->sortBy=='default', function ($query) use ($request) {
            })
            ->with('categories')
            ->paginate(isset($request->pages)?$request->pages:20);
        return view('Website.pages.shops.view-all-shops', compact('shops', 'premiumAds', 'cities', 'rates','cityName'));


    }
    public function show(FilterAdvertisementsRequest $request,$lang,$id,$slug){
        $selectedCountry=CountryService::selectCountry();

         $shop=User::whereId($id)
          ->withCount([
              'advertisements',
              'reviews',
              'followers',
              'views'
          ])
             ->withCount(['followers as is_follow'=>function($query){
                 $query->where('follower_id',auth()->id());
             }])
          ->with(['explores'=>function($query){
              $query->with('hubFiles')->withCount(['shares','likes','comments']);
          },'advertisements'])
          ->first();
//         return $shop->working_hours;
        $now=Carbon::now();
       if($now->between($shop->working_hours[0]->from,$shop->working_hours[0]->to)){
           $shop['is_open']='open-now';
        }
       else{
           $shop['is_open']='closed';

       }

        $minPrice = Advertisement::where('store_id',$id)->whereHas('city',function ($query)use($selectedCountry){
            $query->where('parent_id',$selectedCountry->id);
        })->min('price');
        $maxPrice = Advertisement::where('store_id',$id)->whereHas('city',function ($query)use($selectedCountry){
            $query->where('parent_id',$selectedCountry->id);
        })->max('price');
        $premiumAds = Advertisement::where('store_id',$id)->premium(Constant::PREMIUM_STATUS['True'])->whereHas('city',function ($query)use($selectedCountry){
            $query->where('parent_id',$selectedCountry->id);
        })->orderBy('premium', 'desc')->with('hubFiles')->count();
        $nonPremiumAds = Advertisement::where('store_id',$id)->whereHas('city',function ($query)use($selectedCountry){
            $query->where('parent_id',$selectedCountry->id);
        })->where('premium', 0)->count();
        $premiumAdsSlider = Advertisement::premium(Constant::PREMIUM_STATUS['True'])->whereHas('city',function ($query)use($selectedCountry){
            $query->where('parent_id',$selectedCountry->id);
        })->orderBy('premium', 'desc')->with(['subCategory'=>function($query){
            $query->with('category');
        }])->take(6)->get();

        $rates = Advertisement::where('store_id',$id)->whereHas('city',function ($query)use($selectedCountry){
            $query->where('parent_id',$selectedCountry->id);
        })->get()->groupBy('average_rate');
        $properties = Property::where('parent_id', null)->with(['children' => function ($query) {
            $query->withCount('advertisements');
        }])
            ->whereHas('advertisements',function ($query)use($id){
                $query->where('store_id',$id);
            })
            ->withCount('advertisements')
            ->get();
        $advertisements = Advertisement::where('store_id',$id)
            ->whereHas('city',function ($query)use($selectedCountry){
                $query->where('parent_id',$selectedCountry->id);
            })
            ->when($request->sub_category_id, function ($query) use ($request) {
                $query->whereIn('sub_category_id', $request->sub_category_id);
            })
            ->when($request->text, function ($query) use ($request) {
                $query->where('title','Like','%'.$request->text.'%');
            })
            ->when($request->sort_by && $request->sort_by=='most-rated', function ($query) use ($request) {
                $query->orderBy('average_rate');
            })
            ->when($request->sort_by && $request->sort_by=='latest', function ($query) use ($request) {
                $query->orderBy('created_at');
            })
            ->when($request->min_price && $request->max_price, function ($query) use ($request) {
                $query->whereBetween('price', [$request->min_price , $request->max_price]);
            })
            ->when($request->city_ids, function ($query) use ($request) {
                $query->whereIn('city', $request->city_ids);
            })
            ->when($request->properties, function ($query) use ($request) {
                $query->whereHas('properties', function ($query) use ($request) {
                    foreach ($request->properties as $property) {
                        $query->where('advertisement_property.property_id', $property['id']);
//                            ->when($property['from'] && $property['to'], function ($query) use($property){
//                                $query->whereBetween('advertisement_property.text', [$property['from'], $property['to']]);
//
//                            });
                    }
                });
            })

            ->when($request->advertisement_type && $request->advertisement_type == Constant::FILTER_ADVERTISEMENT_TYPE['Premium'], function ($query) use ($request) {
                $query->where('premium', Constant::PREMIUM_STATUS['True']);
            })
            ->when($request->advertisement_type &&$request->advertisement_type == Constant::FILTER_ADVERTISEMENT_TYPE['Free'], function ($query) use ($request) {
                $query->where('premium', Constant::PREMIUM_STATUS['False']);
            })
            ->with(['subCategory'=>function($query){
                $query->with('category');
            },'city'])
            ->paginate(20);
          $relatedShops=User::CheckUserType(Constant::USER_TYPE['Store'])->orderBy('average_rate')
            ->withCount('advertisements')
            ->withCount(['followers as is_follow' => function ($query) {
                $query->where('follower_id', 1);
            }])
            ->whereHas('categories',function ($query)use($shop){
                $query->whereIn('category_id',$shop->categories->pluck('id')->toArray());
            })
            ->take(6)->get();
        $relatedAdvertisements=Advertisement::whereHas('subCategory',function ($query)use($shop){
            $query->whereIn('parent_id',$shop->categories->pluck('id')->toArray());

        })->orderBy('premium','desc')->take(6)->get();
         $storeReports=Setting::where('key',Constant::SETTING_KEYS['Store Reports'])->get();
         $storeBlocks=Setting::where('key',Constant::SETTING_KEYS['Store Blocks'])->get();

        return view('Website.pages.shops.shop-details', compact('shop', 'premiumAds',
            'minPrice','maxPrice',
             'rates',
            'nonPremiumAds', 'premiumAdsSlider',
            'properties', 'advertisements',
            'relatedShops', 'relatedAdvertisements',
            'storeReports', 'storeBlocks'


        ));


    }
    public function shopsOnMap(){
        $selectedCountry=CountryService::selectCountry();

        $shops=User::getVerifiedUserBasedOnTypeAndCountry(Constant::USER_TYPE['Store'], 1)
            ->with('categories')
            ->latest('id')
            ->take(100)
            ->whereHas('city',function ($query)use($selectedCountry){
                $query->where('parent_id',$selectedCountry->id);
            })
            ->get();
        return view('Website.pages.shops.shops-on-map', compact('shops'));


    }
    public function followedShops(FilterShopsRequest $request,$lang,$city=null)
    {
        $followingIds=auth()->user()->following->pluck('id');
        $citiesIds=auth()->user()->following->pluck('city_id');
        $categories = Category::GetActiveCategories()
            ->whereHas('shops',function ($query)use($followingIds){
                $query->whereIn('id',$followingIds);
            })
            ->withCount(['shops',function ($query)use($followingIds){
                $query->whereIn('id',$followingIds);
            }])
            ->get();
        $cities = Country::GetActiveCities()->whereIn('id',$citiesIds)->withCount('shops')->get();
        $rates = User::CheckUserType(Constant::USER_TYPE['Store'])->whereIn('id',$followingIds)->get()->groupBy('average_rate');
        $premiumAds = Advertisement::premium(Constant::PREMIUM_STATUS['True'])->orderBy('premium', 'desc')->with('hubFiles')->take(6)->get();
        $shops = User::CheckUserType(Constant::USER_TYPE['Store'])
            ->whereIn('id',$followingIds)
            ->orderBy('average_rate')
            ->when($city,function ($query)use ($city){
                $query->whereHas('city', function ($query) use ($city) {
                    $query->whereTranslation('slug', $city);
                });
            })
            ->when($request->category_id,function ($query)use ($request){
                $query->whereHas('categories',function ($query)use ($request){
                    $query->whereIn('category_store.category_id',$request->category_id);
                });
            })
            ->when($request->city_id,function ($query)use ($request){
                $query->whereIn('city_id',$request->city_id);

            })
            ->when($request->rates,function ($query)use ($request){
                $query->whereIn('average_rate',$request->rates);

            })
            ->withCount('advertisements')
            ->withCount(['followers as is_follow' => function ($query) {
                $query->where('user_id', 1);
            }])
            ->paginate(20);
        return view('Website.pages.shops.view-all-shops', compact('shops', 'premiumAds', 'categories', 'cities', 'rates'));


    }
    public function followers($lang,$id){
        $shop=User::whereId($id)->select('id','slug','name')->first();
        $followers=$shop->followers()->paginate();
        return view('Website.pages.shops.followers', compact('followers','shop'));

    }
    public function viewers($lang,$id){
        $shop=User::whereId($id)->select('id','slug','name')->first();
        $viewers=$shop->views()->paginate();
        return view('Website.pages.shops.views', compact('viewers','shop'));

    }
    public function reviews($lang,$id){
        $shop=User::whereId($id)->select('id','slug','name','average_rate')->withCount('reviews')->first();
        $reviews=$shop->reviews()->paginate();
        return view('Website.pages.shops.reviews', compact('reviews','shop'));

    }

}
