<?php

namespace App\Http\Requests\Api\V100\Explore;

use App\Helpers\Constant;
use App\Services\RespondActive;
use Illuminate\Contracts\Validation\Validator;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\Exceptions\HttpResponseException;
use Illuminate\Validation\Rule;

class SetExploreUserRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'explore_id'    => ['required', Rule::exists('explores', 'id')],
            'type'          => [
                'required',
                Rule::in([
                    \App\Helpers\Constant::EXPLORE_USER_TYPE['Like'],
                    \App\Helpers\Constant::EXPLORE_USER_TYPE['Comment'],
                    \App\Helpers\Constant::EXPLORE_USER_TYPE['Share'],
                ])
            ],
            'comment'       => [
                'required_if:type,'.\App\Helpers\Constant::EXPLORE_USER_TYPE['Comment'],
                'string',
                'max:400'
            ]
        ];
    }

    protected function failedValidation(Validator $validator)
    {
        throw new HttpResponseException(RespondActive::clientError(
            RespondActive::stringifyErrors($validator->errors())
        ));
    }
}
