<?php

namespace App\Http\Requests\Api\V100\Setting;

use App\Helpers\Constant;
use App\Services\RespondActive;
use Illuminate\Contracts\Validation\Validator;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\Exceptions\HttpResponseException;
use Illuminate\Validation\Rule;

class GetSettingRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'type'      => ['required',
                Rule::in([
                    Constant::SETTING_KEYS['Welcome'],
                    Constant::SETTING_KEYS['Contact us'],
                    Constant::SETTING_KEYS['Social media'],
                    Constant::SETTING_KEYS['Advertisement Reports'],
                    Constant::SETTING_KEYS['Store Reports'],
                    Constant::SETTING_KEYS['Store Blocks'],
                ]),
            ],
        ];
    }

    protected function failedValidation(Validator $validator)
    {
        throw new HttpResponseException(RespondActive::clientError(
            RespondActive::stringifyErrors($validator->errors())
        ));
    }
}
