<?php

namespace App\Http\Requests\Website\V100;

use Illuminate\Foundation\Http\FormRequest;

class AuthRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'phone'         => ['nullable', 'max:150'],
            'country_code'  => ['required', 'max:6']
        ];
    }
    public function messages()
    {
        return [
            'phone.required'=>__('website.phone-required'),
            'country_code.required'=>__('website.country_code-required'),
        ];

    }
}
