<?php

namespace App\Http\Requests\Website\V100;

use App\Helpers\Constant;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class FilterAdvertisementsRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'category'    => ['nullable','max:50'],
            'text'    => ['nullable','max:50'],
            'category_id'    => ['nullable','array','min:1'],
//            'category_id.*'   => ['exists:categories,id'],
            'sub_category_id'    => ['nullable','array','min:1'],
//            'sub_category_id.*'   => ['exists:categories,id'],
            'city_id'    => ['nullable','array','min:1'],
//            'city_id.*'   => ['exists:countries,id'],
            'rates'    => ['nullable','array','min:1'],
            'properties'        => ['nullable', 'array', 'min:1'],
            'properties.*'   => ['nullable', Rule::exists('properties', 'id')],
            'min_price'         => ['nullable', 'numeric', 'min:0'],
            'max_price'         => ['nullable', 'numeric'],
            'advertisement_type' => [
                'nullable',
                'array'
            ],
            'sortBy'        => ['nullable', 'in:rated,price,date'],
            'type'        => ['nullable', 'in:View,Search'],


        ];
    }
}
