<?php

namespace App\Http\Requests\Website\V100;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class FilterShopsRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'category_id'    => ['nullable','array','min:1'],
            'category_id.*'   => ['exists:categories,id'],
            'city_id'    => ['nullable','array','min:1'],
            'city_id.*'   => ['exists:countries,id'],
            'rates'    => ['nullable','array','min:1'],

        ];
    }
}
