<?php

namespace App\Http\Requests\Website\V100;

use App\Helpers\Constant;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class SetExploreUserRequest  extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'explore_id'    => ['required', Rule::exists('explores', 'id')],
            'type'          => [
                'required',
                Rule::in([
                    \App\Helpers\Constant::EXPLORE_USER_TYPE['Like'],
                    \App\Helpers\Constant::EXPLORE_USER_TYPE['Share'],
                ])
            ]        ];
    }}
