<?php

namespace App\Http\Requests\Website\V100;

use App\Helpers\Constant;
use App\Services\RespondActive;
use Illuminate\Contracts\Validation\Validator;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\Exceptions\HttpResponseException;
use Illuminate\Validation\Rule;

class UpdateUserProfileRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'name'          => ['nullable', 'string', 'max:190'],
            'phone'         => [
                'required',
                Rule::unique('users')
                    ->whereNot('id', auth()->id())
            ],
            'country_code'  => ['required', 'max:6'],
            'email'         => [
                'nullable',
                Rule::unique('users')
                    ->whereNot('id', auth()->id())
            ],
            'image'         => ['nullable'],
        ];
    }

    protected function prepareForValidation()
    {
        if (request()->phone != auth()->user()->phone) {
            $this->merge([
                'verified' => 0
            ]);
        }
    }
    public function messages()
    {
        return [
            'email.unique'=>__('website.email-unique'),
            'phone.unique'=>__('website.phone-unique'),
            'country_code.required'=>__('website.country_code-required'),
        ];

    }


//    protected function failedValidation(Validator $validator)
//    {
//        throw new HttpResponseException(RespondActive::clientError(
//            RespondActive::stringifyErrors($validator->errors())
//        ));
//    }
}
