<?php

namespace App\Http\Resources\Advertisement;

use App\Helpers\Constant;
use App\Http\Resources\Category\CategoryResource;
use App\Http\Resources\Country\CountryResource;
use App\Http\Resources\User\StoreResource;
use Illuminate\Http\Resources\Json\JsonResource;

class AdvertisementResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        return [
            'id'                => $this->id,
            'title'             => $this->title,
            'price'             => $this->price,
            'premium'           => $this->premium,
            'is_negotiable'     => $this->is_negotiable,
            'created_at'        => $this->created_at->diffForHumans(),
            'views_count'       => $this->views_count,
            'favorite_count'    => $this->favorite_count,
            'share_count'       => $this->share_count,
            'latitude'          => $this->latitude,
            'longitude'         => $this->longitude,
            'category'          => new CategoryResource($this->whenLoaded('subCategory.category')),
            'is_favorite'       => auth('sanctum')->user() &&
            auth('sanctum')->user()
            ->advertisementsActionsByType(Constant::ADVERTISEMENT_USER_TYPE['Favorite'])
            ->exists($this->id),
            'average_rate'      => $this->average_rate,
            'image'             => $this->image(),
            'store'             => new StoreResource($this->whenLoaded('user')),
            'country'           => new CountryResource($this->city->country),
            'city'              => new CountryResource($this->whenLoaded('city')),
        ];
    }
}
