<?php

namespace App\Http\Resources\Advertisement;

use App\Http\Resources\User\UserResource;
use Illuminate\Http\Resources\Json\JsonResource;

class ReviewResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'user'      => new UserResource($this),
            'rate'      => $this->pivot->rate,
            'review'    => $this->pivot->review,
            'date'      => $this->pivot->created_at->translatedFormat('Y-m-d')
        ];
    }
}
