<?php

namespace App\Http\Resources\Category;

use App\Http\Resources\Advertisement\AdvertisementResource;
use Illuminate\Http\Resources\Json\JsonResource;

class CategoryResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        return [
            'id'                => $this->id,
            'name'              => $this->name,
            'image'             => $this->image(),
            $this->mergeWhen($this->relationLoaded('advertisements'), function (){
                return [
                    'advertisements'    => AdvertisementResource::collection(
                        $this->advertisements()->with('city', 'user')->paginate(5)
                    )
                ];
            }),
            'sub-categories'    => CategoryResource::collection($this->whenLoaded('subCategories'))
        ];
    }
}
