<?php

namespace App\Http\Resources;

use App\Helpers\Constant;
use App\Http\Resources\Advertisement\AdvertisementResource;
use App\Http\Resources\User\StoreResource;
use App\Services\Advertisement\AdvertisementService;
use App\Services\User\StoreService;
use Illuminate\Http\Resources\Json\ResourceCollection;

class HomeCollection extends ResourceCollection
{
    /**
     * Transform the resource collection into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        return [
            'most-rated-stores' => StoreResource::collection(
                StoreService::storesBasedOnParameters([
                    'premium'   => Constant::PREMIUM_STATUS['True'],
                    'most_rated'=> true,
                    'limit'     => 5
                ])
            ),
            'followings-stores' => StoreResource::collection(
                StoreService::storesBasedOnParameters([
                    'followers' => true,
                    'limit'     => 5
                ]),
            ),
            'suggested-ads'     => AdvertisementResource::collection(
                AdvertisementService::advertisementsBasedOnParameters([
                    'premium'   => Constant::PREMIUM_STATUS['True'],
                    'random'    => true,
                    'orderBy'   => 'desc',
                    'limit'     => 5
                ])
            ),
            'most-popular-ads'  => AdvertisementResource::collection(
                AdvertisementService::advertisementsBasedOnParameters([
                    'premium'   => Constant::PREMIUM_STATUS['True'],
                    'most_rated'=> true,
                    'limit'     => 5
                ])
            ),
            'category-ads'  => $this->collection,
        ];
    }
}
