<?php

namespace App\Http\Resources\User;

use App\Helpers\Constant;
use Illuminate\Http\Resources\Json\JsonResource;

class NotificationResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'id'            => $this->id,
            'text'          => $this->text,
            'notify_type'   => $this->notify_type,
            'action_by_id'  => $this->action_by_id,
            'created_at'    => $this->created_at->format('d F Y H:i'),
            'logo'          => getImage(settings(Constant::SETTING_KEYS['Logo'])->first()->image),
            'image'         => $this->image(),
        ];
    }
}
