<?php

namespace App\Models;

use App\Models\BlogComment;
use Astrotomic\Translatable\Translatable;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Blog extends Model
{
    use HasFactory, Translatable;

    public $translatedAttributes = ['title', 'description','slug','quote'];

    protected $fillable = [
        'author_id',
        'share_count',
        'country_id',
    ];
    protected $with=['translations','author'];

    public function image()
    {
        $this->load('hubFiles');

        return $this->hubFiles?$this->hubFiles->get_path():'website/images/blog/02.jpg';
    }
    public function author(){
        return $this->belongsTo(Admin::class,'author_id','id');
    }
    public function comments(){
        return $this->hasMany(BlogComment::class,'blog_id','id');
    }
    public function getCreatedAtAttribute($value){
        return Carbon::parse($value)->locale(app()->getLocale())->translatedFormat('l,d M Y');
    }
    public function getUpdatedAtAttribute($value){
        return Carbon::parse($value)->locale(app()->getLocale())->translatedFormat('l,d M Y');

 }
    public function hubFiles()
    {
        return $this->morphOne(HubFile::class, 'morphable');
    }
    public function countries()
    {
        return $this->belongsToMany(Country::class)->withTimestamps();
    }

}
