<?php

namespace App\Models;

use App\Helpers\Constant;
use Astrotomic\Translatable\Translatable;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Category extends Model
{
    use HasFactory, Translatable;

    public $translatedAttributes = ['name', 'slug'];

    protected $fillable = [
        'active',
        'app_home',
        'parent_id'
    ];
    protected $with='translations';
    public function image()
    {
        $this->load('hubFiles');

        return $this->hubFiles[0]?->get_path();
    }
//    public function webSiteImage()
//    {
//        $this->load('hubFiles');
//
//        return $this->hubFiles[1]?->get_path();
//    }

    public function scopeGetActiveCategories($query)
    {
        $query->where('active', Constant::CATEGORY_STATUS['Active'])->whereNull('parent_id');
    }

    public function scopeGetActiveSubCategories($query)
    {
        $query->where('active', Constant::CATEGORY_STATUS['Active'])->whereNotNull('parent_id');
    }

    public function category()
    {
        return $this->belongsTo(Category::class, 'parent_id');
    }

    public function subCategories()
    {
        return $this->hasMany(Category::class, 'parent_id');
    }

    public function scopeSearch($query, $keyWord)
    {
        $query->when(request()->search, function ($query) use ($keyWord) {
            $query->where('name', 'like', '%'.$keyWord.'%');
        });
    }

    public function advertisements()
    {
        return $this->hasMany(Advertisement::class, 'sub_category_id');
    }

    public function categoryAdvertisements()
    {
        return $this->hasManyThrough(
            Advertisement::class,
            Category::class,
            'parent_id',
            'sub_category_id',
            'id',
            'id'
        );
    }
    public function hubFiles()
    {
        return $this->morphMany(HubFile::class, 'morphable');
    }

    public function properties()
    {
        return $this->belongsToMany(Property::class)->with('translation')->withTimestamps();
    }
    public function shops()
    {
        return $this->belongsToMany(User::class,'category_store','id','store_id')->withTimestamps();
    }

}
