<?php

namespace App\Models;

use App\Helpers\Constant;
use Astrotomic\Translatable\Translatable;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Country extends Model
{
    use HasFactory, Translatable;

    public $translatedAttributes = ['name', 'currency','slug'];

    protected $fillable = [
        'id',
        'parent_id',
        'active',
    ];
    protected $with='translations';

    public function image()
    {
        $this->load('hubFiles');

        return $this->hubFiles?->get_path();
    }

    public function scopeGetActiveCountries($query)
    {
        $query->where('active', Constant::COUNTRY_STATUS['Active'])->whereNull('parent_id');
    }

    public function scopeGetActiveCities($query)
    {
        $query->where('active', Constant::COUNTRY_STATUS['Active'])->whereNotNull('parent_id');
    }

    public function country()
    {
        return $this->belongsTo(Country::class, 'parent_id');
    }

    public function cities()
    {
        return $this->hasMany(Country::class, 'parent_id');
    }

    public function hubFiles()
    {
        return $this->morphOne(HubFile::class, 'morphable');
    }
    public function shops(){
        return $this->hasMany(User::class,'city_id','id')->checkUserType(Constant::USER_TYPE['Store']);
    }
    public function advertisements(){
        return $this->hasMany(Advertisement::class,'city_id','id');
    }
}
