<?php

namespace App\Models;

use App\Helpers\Constant;
use Astrotomic\Translatable\Translatable;
use Illuminate\Database\Eloquent\Model;

class Setting extends Model
{
    use Translatable;

    public $translatedAttributes = ['title', 'content'];

    protected $fillable = [
        'id',
        'key',
        'image',
    ];
    protected $with='translations';

    protected static function boot()
    {
        parent::boot();
        static::updating(function () {
            cache()->forget('settings');
        });
    }

    public function keys()
    {
        if ($this->key == Constant::SETTING_KEYS['Welcome']){
            return __('Welcome');
        }if ($this->key == Constant::SETTING_KEYS['Contact us']){
            return __('Contact us');
        }if ($this->key == Constant::SETTING_KEYS['Social media']){
            return __('Social media');
        }if ($this->key == Constant::SETTING_KEYS['About us']){
            return __('About us');
        }if ($this->key == Constant::SETTING_KEYS['Terms conditions']){
            return __('Terms conditions');
        }if ($this->key == Constant::SETTING_KEYS['Advertisement Reports']){
            return __('Advertisement Reports');
        }if ($this->key == Constant::SETTING_KEYS['Store Reports']){
            return __('Store Reports');
        }if ($this->key == Constant::SETTING_KEYS['Store Blocks']){
            return __('Store Blocks');
        }
    }
}
