<?php

namespace App\Models;

use Astrotomic\Translatable\Translatable;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Team extends Model
{
    use HasFactory,Translatable;

    public $translatedAttributes = ['name', 'position'];

    protected $fillable = [
        'id',
    ];
    protected $with='translations';

    public function hubFiles()
    {
        return $this->morphOne(HubFile::class, 'morphable');
    }
    public function image()
    {
        $this->load('hubFiles');

        return $this->hubFiles?->get_path();
    }

}
