<?php

namespace App\Services\Auth;

use App\Helpers\Constant;
use App\Http\Resources\User\StoreResource;
use App\Models\User;
use App\Models\VerificationCode;

class VerificationService
{

    /**
     * Verification Code User Account.
     * @param $user_id
     * @param $objective ['verify', 'reset']
     * @param $information_type ['phone', 'email']
     * @param $information
     */
    public static function verifyAccount($user_id, $objective, $information_type, $information, $country_code=null): void
    {
//        dd($country_code);
//        $activation_code = rand(1000, 9999);

//        TwilioSMS::send([
//            'phone'             => $information,
//            'country_code'      => $country_code,
//            'verification_code' => $activation_code
//        ]);

        VerificationCode::updateOrInsert(
            [
                'user_id'           => $user_id,
                'objective'         => $objective,
                'information_type'  => $information_type,
                'information'       => $information,
            ],
            [
                'code'              => '1111',
                'used'              => Constant::VERIFICATION_USED['Not used'],
                'expired_at'        => now()->addHour()->toDateTimeString(),
                'created_at'        => now(),
            ]
        );
    }}
