<?php

namespace App\Services\External;

use App\Models\Notification as NotificationModel;
use App\Models\PersonalFirebaseToken;

class Notification
{
    /**
     * Method a query to only notify users
     * @param  $notify_type
     * @param  $user_id
     * @param  $action_by_id
     * @param  $class_id
     * @param  $title
     * @param  $body
     * @return void
     */
    public static function notify($notify_type, $user_id, $action_by_id, $class_id = null, $title, $body):void
    {
        NotificationModel::create([
            'notify_type'   =>  $notify_type,
            'user_id'       =>  $user_id,
            'action_by_id'  =>  $action_by_id,
            'class_id'      =>  $class_id,
            'text'          =>  $body
        ]);

        $device_token = PersonalFirebaseToken::where('user_id', $user_id)->pluck('firebase_token')->toArray();

        $data = [
            'type'          => $notify_type,
            'user_id'       => $user_id,
            'action_by_id'  => $action_by_id,
            'class_id'      => $class_id,
            'title'         => $title,
            'body'          => $body,
            'sound'         => 'default',
        ];

        FCM::send($device_token, $data);
    }
}
