<?php


namespace App\Services\Website;


use App\Helpers\Constant;
use App\Models\Advertisement;
use App\Models\Country;
use App\Models\User;
use Illuminate\Support\Facades\Session;

class ShopService
{
    public static function shops($selectedCountry,$follow=false)
    {


        return User::checkUserType(Constant::USER_TYPE['Store'])
            ->where('complete_profile', 1)
            ->whereHas('city', function ($query) use ($selectedCountry) {
                $query->where('parent_id', $selectedCountry->id);
            })
            ->whereHas('newStories')
            ->with(['categories', 'newStories', 'stories' => function ($query) {
                $query->with('hubFiles');
            }])
            ->withCount(['advertisements', 'views', 'followers as is_follow' => function ($query) {

                $query->where('follower_id', auth()->id());
            }])
            ->orderBy('average_rate', 'desc')
            ->take(10);



    }
}
