<?php

namespace App\Services\Website;

use App\Helpers\Constant;
use App\Http\Resources\User\StoreResource;
use App\Models\User;
use App\Models\VerificationCode;
use App\Services\Website\TwilioSMS;

class VerificationService
{

    /**
     * Verification Code User Account.
     * @param $user_id
     * @param $objective ['verify', 'reset']
     * @param $information_type ['phone', 'email']
     * @param $information
     */
    public static function verifyAccount($user_id, $objective, $information_type, $information, $country_code=null): void
    {
        $activation_code = rand(1000, 9999);

        try {
            TwilioSMS::send([
                'phone'             => $information,
                'verification_code' => $activation_code
            ]);
        } catch (\Exception $e) {
            throw new \Exception();
        }

        VerificationCode::updateOrInsert(
            [
                'user_id'           => $user_id,
                'objective'         => $objective,
                'information_type'  => $information_type,
                'information'       => $information,
            ],
            [
                'code'              => $activation_code,
                'used'              => Constant::VERIFICATION_USED['Not used'],
                'expired_at'        => now()->addHour()->toDateTimeString(),
                'created_at'        => now(),
            ]
        );
    }
}
