<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('countries', function (Blueprint $table) {
            $table->id();
            $table->foreignId('parent_id')->nullable()->references('id')
                ->on('countries')->nullOnDelete();
            $table->boolean('active')->default(\App\Helpers\Constant::COUNTRY_STATUS['Active']);
            $table->char('country_code', 4);
            $table->timestamps();
        });

        Schema::create('country_translations', function(Blueprint $table) {
            $table->id();
            $table->foreignId('country_id')->nullable()->constrained()->nullOnDelete();
            $table->string('locale', 2)->index();
            $table->string('name');
            $table->string('currency', 50)->nullable();

            $table->unique(['country_id','locale']);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('countries');
    }
};
