<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('users', function (Blueprint $table) {
            $table->id();
            $table->tinyInteger('account_type');
            $table->boolean('verified')->default(\App\Helpers\Constant::USER_STATUS['Not verified']);
            $table->tinyInteger('registration_step')->default(\App\Helpers\Constant::STORE_REGISTRATION_STEP['First']); //store
            $table->boolean('complete_registration')->default(\App\Helpers\Constant::STORE_COMPLETE_REGISTRATION['Not completed']);
            $table->string('name')->nullable();
            $table->string('nickname')->nullable();
            $table->string('slug')->nullable();
            $table->string('phone')->nullable();
            $table->string('country_code', 6)->nullable();
            $table->string('email')->nullable();
            $table->timestamp('email_verified_at')->nullable();
            $table->string('password')->nullable();
            $table->foreignId('city_id')->nullable()->references('id')
                ->on('countries')->nullOnDelete();
            $table->foreignId('package_id')->nullable()->references('id')
                ->on('packages')->nullOnDelete();
            $table->string('website')->nullable();
            $table->double('latitude')->nullable();
            $table->double('longitude')->nullable();
            $table->string('address')->nullable();
            $table->boolean('premium')->default(\App\Helpers\Constant::PREMIUM_STATUS['False']);
            $table->boolean('social_media')->default(false);
            $table->tinyInteger('social_media_objective')->nullable(); //\App\Helpers\Constant::SOCIAL_MEDIA_TYPE
            $table->text('social_media_provider_id')->nullable();
            $table->float('average_rate', 8 , 1)->default(0);
            $table->integer('rate_count')->default(0);
            $table->integer('notification_count')->default(0);
            $table->tinyInteger('platform')->nullable(); //\App\Helpers\Constant::USER_PLATFORM
            $table->string('background_image')->nullable();
            $table->text('social_media_links')->nullable();
            $table->text('working_hours')->nullable();
            $table->text('description')->nullable();
            $table->rememberToken();
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('users');
    }
};
