@extends('Website.auth.layouts.app')
@section('page-title')
    {{__('website.login')}}
@endsection
@section('extra-css')
    <link rel="stylesheet" href="{{asset('website/css/custom/style-validation.css')}}">


@endsection

@section('content')
    <section class="user-form-part">
        <div class="user-form-banner">
            <div class="user-form-content">
                <a href="{{route('website.index')}}">
                    <img src="{{asset('website/images/logo.png')}}" alt="logo">
                </a>
                <h1>{{__('website.advertise-your-assets')}} <span>{{__('website.advertise-your-assets')}}.</span></h1>
                <p>{{__('website.biggest-online-advertising-marketplace')}}</p>
            </div>
        </div>
        <div class="user-form-category">
            <div class="user-form-header">
                <a href="{{route('website.index')}}">
                    <img src="{{asset('website/images/logo-dark.png')}}" alt="logo"></a>
                <a href="{{route('website.index')}}">
                    <i class="fas fa-arrow-left"></i>
                </a>
            </div>

            <div class="tab-pane active mt-5" id="login-tab">
                <div class="user-form-title">
                    <img src="{{asset('website/images/logo-login.png')}}" alt="logo-moon" class="img-fluid mw-35 mb-5">
                    <h2>{{__('website.welcome')}}!</h2>
                    <p>
                        {{__('website.please-enter-phone')}}

                        <br>
                        {{__('website.take-advantage')}}

                    </p>
                </div>
                @if ($errors->any())
                    @foreach ($errors->all() as $error)
                        <div class="alert alert-danger inverse alert-dismissible fade show" role="alert"><i class="icon-thumb-down"></i>

                            <p>{{ $error }}</p>
                            <button class="close" type="button" data-dismiss="alert" aria-label="Close" data-original-title="" title=""><span aria-hidden="true">×</span></button>

                        </div>

                    @endforeach
                @endif

                <form action="{{route('website.submit.login')}}" method="post" id="login-form">
                   @csrf
                    <div class="row">
                        <div class="col-12">
                            <div class="form-group">
{{--                                <span class="notvalid"> --}}
                                    <input type="tel" id="phone"   class="form-control" placeholder="{{__('website.phone')}}">
                                {{--
 </span>--}}
                                <span id="valid-msg" class="checkValidNumber fa fa-check-circle hide"></span>
                                <span id="error-msg" class="checkInValidNumber fa fa-times-circle hide"></span>                            </div>
                        </div>


                        <div class="col-12">
                            <div class="form-group">
                                <button type="button" id="login" class="btn btn-inline">
                                    <i class="fas fa-unlock"></i>
                                    {{__('website.login-now')}}
                                </button>
                            </div>
                        </div>
                    </div>
                </form>
                <div class="user-form-devider">
                    <p>{{__('website.or')}}</p>
                </div>
                <ul class="user-form-option">
                    <li><a href="{{route('socialLogin.redirect','facebook')}}"><i class="fab fa-facebook-f"></i><span>{{__('website.facebook')}}</span></a></li>
                    <li><a href="#"><i class="fab fa-twitter"></i><span>{{__('website.twitter')}}</span></a></li>
                    <li><a href="#"><i class="fab fa-google"></i><span>{{__('website.google')}}</span></a></li>
                </ul>
                <div class="user-form-direction">
                    <p>{{__('website.login-as-a-shop')}} ?  <span>
                            <a target="_blank" class="secondary-color" href="https://moontest.my-staff.net/store/register">{{__('website.login')}}</a>
                        </span>
                    </p>
                </div>


            </div>

        </div>
    </section>

@endsection
@section('extra-js')
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/1.11.1/jquery.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/11.0.9/js/intlTelInput.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/11.0.9/js/intlTelInput.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/11.0.9/js/utils.js"></script>

    <script src="{{asset('website/js/custom/script-validation.js')}}"></script>

@endsection
