@extends('Website.layouts.app')
@section('extra-css')

    <link rel="stylesheet" href="{{asset('website/css/custom/notification.css')}}">

@endsection
@section('page-title')
    {{__('website.notifications')}}
@endsection

@section('content')
    @if(count($notifications)>0)

    <section class="notify-part">
        <div class="container">
            <div class="row">
                <div class="col-lg-12 mx-auto">
                    <div class="notify-body">
                        <div class="notify-filter">
                            <select class="select notify-select" style="display: none;">
                                <option value="">{{__('website.all-notifications')}}</option>
                                <option value="">{{__('website.moon-notifications')}}</option>
                                <option value="">{{__('website.shop-notifications')}}</option>
                            </select>
                        </div>
                        @if(count($notifications)>0)
                            <ul class="notify-list notify-scroll">
                                @foreach($notifications as $notification)
                                    <li class="notify-item @if($notification->seen==0)active @endif">

                                    @if($notification->type==\App\Helpers\Constant::NOTIFICATION_TYPE['Store'])
                                            <a href="{{route('website.shop-details',['id'=>$notification->action_by_id,'slug'=>$notification->store->slug])}}" class="notify-link">
                                                <div class="notify-img"><img
                                                        src="{{$notification->store->image()?$notification->store->image():'website/images/favicon.png'}}"
                                                        alt="avatar"></div>
                                                <div class="notify-content">
                                                    <p class="notify-text">
                                                        <span>{{$notification->store->name}}</span><br>
                                                        {{$notification->text}}</span></p>
                                                    <span class="notify-time">{{$notification->created_at}}</span>
                                                </div>
                                            </a>
                                    @elseif($notification->type==\App\Helpers\Constant::NOTIFICATION_TYPE['Advertisement'])
                                            <a href="{{route('website.advertisement-details',['id'=>$notification->action_by_id,'slug'=>$notification->advertisement->slug])}}" class="notify-link">
                                                <div class="notify-img"><img
                                                        src="{{$notification->advertisement->image()?$notification->advertisement->image():'website/images/favicon.png'}}"
                                                        alt="avatar"></div>
                                                <div class="notify-content">
                                                    <p class="notify-text">
                                                        <span>{{$notification->advertisement->title}}</span><br>
                                                        {{$notification->text}}
                                                    </p>
                                                    <span class="notify-time">{{$notification->created_at}}</span>
                                                </div>
                                            </a>

                                    @else
                                            <a href="javascript:void(0)" class="notify-link">
                                                <div class="notify-img"><img
                                                        src="{{\App\Models\Setting::where('key',\App\Helpers\Constant::SETTING_KEYS['Logo'])->first()?getImage(\App\Models\Setting::where('key',\App\Helpers\Constant::SETTING_KEYS['Logo'])->first()->image):'website/images/favicon.png'}}"
                                                        alt="avatar"></div>
                                                <div class="notify-content">
                                                    <br class="notify-text">
                                                        <span>{{__('website.admin')}}</span><br>
                                                        {{$notification->text}}
                                                    </p>
                                                    <span class="notify-time">{{$notification->created_at}}</span>
                                                </div>
                                            </a>


                                    @endif
                                    </li>
                                @endforeach
                            </ul>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </section>
    @else
        @include('Website.pages.errors.empty')

    @endif

@endsection
@section('extra-js-files')
    <script src="{{asset('website/js/vendor/nice-select.min.js')}}"></script>
    <script src="{{asset('website/js/vendor/nicescroll.min.js')}}"></script>
    <script src="{{asset('website/js/custom/nice-select.js')}}"></script>
    <script src="{{asset('website/js/custom/nicescroll.js')}}"></script>

@endsection
