@extends('Website.layouts.app')
@section('extra-css')
    <link rel="stylesheet" href="{{asset('website/css/custom/contact.css')}}">
    <link rel="stylesheet" href="{{asset('website/css/custom/style-upload.css')}}">
    <link href="https://maxcdn.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css" rel="stylesheet" >


@endsection
@section('profile-css')
    <link rel="stylesheet" href="@if(app()->getLocale()=='en'){{asset('website/css/custom/style-validation.css')}} @else
    {{asset('website/css/custom/style-validation-rtl.css')}}
    @endif">

@endsection

@section('page-title')
    {{__('website.profile')}}
@endsection

@section('banner')
 <section class="single-banner">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <div class="single-content">
                        <h1>{{__('website.edit-profile')}}</h1>
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="{{route('website.index')}}">{{__('website.home')}}</a></li>
                            <li class="breadcrumb-item active" aria-current="page">{{__('website.edit-profile')}}</li>
                        </ol>
                    </div>
                </div>
            </div>
        </div>
 </section>

@endsection
@section('content')

<section class="contact-part">
    <div class="container">

        <div class="row">

            <div class="col-lg-12">
                @if ($errors->any())
                    @foreach ($errors->all() as $error)
                        <div class="alert alert-danger inverse alert-dismissible fade show" role="alert"><i class="icon-thumb-down"></i>

                            <p>{{ $error }}</p>
                            <button class="close" type="button" data-dismiss="alert" aria-label="Close" data-original-title="" title=""><span aria-hidden="true">×</span></button>

                        </div>

                    @endforeach
                @endif

                <form class="contact-form" action="{{route('website.update-profile')}}" method="post" enctype="multipart/form-data" id="update-form">
                    @csrf
                    <div class="col-lg-12">

                    </div>

                    <div class="avatar-upload">
                        <div class="avatar-edit">
                            <input type='file' id="imageUpload" name="image" accept=".png, .jpg, .jpeg" />
                            <label for="imageUpload"></label>
                        </div>
                        <div class="avatar-preview">
                            <div id="imagePreview" style="background-image: url({{auth()->user()->image()?auth()->user()->image():'/website/images/avatar/profile-default.png'}});">
                            </div>
                        </div>
                    </div>

                    <div class="row">

                        <div class="col-lg-12">
                            <div class="form-group">
                                <input type="text" class="form-control" placeholder="{{__('website.name')}}" name="name" value="{{auth()->user()->name}} ">
                            </div>
                        </div>
                        <div class="col-lg-12">
                            <div class="form-group">
                                <input type="email" class="form-control" placeholder="{{__('website.email')}}" name="email" value="{{auth()->user()->email}}">
                            </div>
                        </div>
                        <div class="col-lg-12">
                            <div class="form-group">
                                <input type="tel" id="phone" class="form-control" placeholder="{{__('website.phone')}}" name="phone" value="{{auth()->user()->phone}}">
                                <span id="valid-msg" class="checkValidNumber checkInValidNumber-profile fa fa-check-circle hide"></span>
                                <span id="error-msg" class="checkInValidNumber checkInValidNumber-profile fa fa-times-circle hide"></span>                            </div>

                        </div>
                        </div>
                        <div class="col-lg-12">
                            <div class="form-btn"><button class="btn btn-inline" type="button" id="update"><i class="fas fa-pen"></i><span>{{__('website.update-profile')}}</span></button></div>
                        </div>
                    </div>
                </form>

                    </div>
            </div>
        </div>
    </div>
</section>
@endsection
@section('extra-js-files')
    <script src="{{asset('website/js/custom/script-upload.js')}}"></script>
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/1.11.1/jquery.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/11.0.9/js/intlTelInput.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/11.0.9/js/intlTelInput.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/11.0.9/js/utils.js"></script>

    <script>
        var telInput = $("#phone"),
            errorMsg = $("#error-msg"),
            validMsg = $("#valid-msg"),
            countryCodeNewInput = document.createElement("INPUT"),
            phoneWithInput = document.createElement("INPUT"),
            fullPhoneInput = document.createElement("INPUT"),
            updateForm = $("#update-form"),
            updateButton = $("#update");


        // initialise plugin
        telInput.intlTelInput({

            allowExtensions: true,
            formatOnDisplay: true,
            autoFormat: true,
            autoHideDialCode: true,
            autoPlaceholder: true,
            defaultCountry: "auto",
            ipinfoToken: "yolo",
            hiddenInput: "full_phone",
            setCountry:'{{$country}}',
            nationalMode: true,
            numberType: "MOBILE",
            placeholderNumberType : "MOBILE",
            //onlyCountries: ['us', 'gb', 'ch', 'ca', 'do'],
            preferredCountries: ['sa', 'ae', 'qa','om','bh','kw','ma'],
            preventInvalidNumbers: true,
            separateDialCode: true,
            initialCountry: '{{$country}}',
            geoIpLookup: function(callback) {
                $.get("https://ipinfo.io", function() {}, "jsonp").always(function(resp) {

                    var countryCode = (resp && resp.country) ? resp.country : "";
                    // var countryCode = ;
                    callback(countryCode);

                });
            },
            utilsScript: "https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/11.0.9/js/utils.js"
        });

        var reset = function() {
            telInput.removeClass("error");
            errorMsg.addClass("hide");
            validMsg.addClass("hide");

        };

        // on blur: validate
        updateButton.click(function() {
            reset();
            if ($.trim(telInput.val())) {
                if (telInput.intlTelInput("isValidNumber")) {
                    validMsg.removeClass("hide");
                    countryCodeNewInput.setAttribute("type", "hidden");
                    countryCodeNewInput.setAttribute("name", "country_code");
                    countryCodeNewInput.setAttribute("value",$('.selected-dial-code').text());
                    updateForm.append(countryCodeNewInput);
                    var string = telInput.intlTelInput("getNumber");
                    phone = string.replace($('.selected-dial-code').text(),'');
                    phoneWithInput.setAttribute("type", "hidden");
                    phoneWithInput.setAttribute("name", "phone");
                    phoneWithInput.setAttribute("value", phone);
                    updateForm.append(phoneWithInput);
                    // fullPhoneInput.setAttribute("type", "hidden");
                    // fullPhoneInput.setAttribute("name", "full_phone");
                    // fullPhoneInput.setAttribute("value", telInput.intlTelInput("getNumber"));
                    // loginForm.append(fullPhoneInput);


                    updateForm.submit();

                } else {
                    telInput.addClass("error");
                    errorMsg.removeClass("hide");

                }
            }
        });
        telInput.on('keypress',function(e) {
            reset();
            if(e.which == 13) {

                if ($.trim(telInput.val())) {
                    if (telInput.intlTelInput("isValidNumber")) {
                        validMsg.removeClass("hide");
                        countryCodeNewInput.setAttribute("type", "hidden");
                        countryCodeNewInput.setAttribute("name", "country_code");
                        countryCodeNewInput.setAttribute("value", $('.selected-dial-code').text());
                        updateForm.append(countryCodeNewInput);
                        var string = telInput.intlTelInput("getNumber");
                        phone = string.replace($('.selected-dial-code').text(), '');
                        phoneWithInput.setAttribute("type", "hidden");
                        phoneWithInput.setAttribute("name", "phone");
                        phoneWithInput.setAttribute("value", phone);
                        updateForm.append(phoneWithInput);
                        // fullPhoneInput.setAttribute("type", "hidden");
                        // fullPhoneInput.setAttribute("name", "full_phone");
                        // fullPhoneInput.setAttribute("value", telInput.intlTelInput("getNumber"));
                        // loginForm.append(fullPhoneInput);


                        updateForm.submit();

                    } else {
                        telInput.addClass("error");
                        errorMsg.removeClass("hide");

                    }
                }
            }
        });

        // on keyup / change flag: reset
        telInput.on("keyup change", reset);


    </script>

@endsection

