@extends('Website.auth.layouts.app')
@section('page-title')
    {{__('website.verify')}}
@endsection

@section('content')

    <section class="user-form-part">
        <div class="user-form-banner">
            <div class="user-form-content">
                <a href="{{route('website.index')}}">
                    <img src="{{asset('website/images/logo.png')}}" alt="logo">
                </a>
                <h1>{{__('website.advertise-your-assets')}} <span>{{__('website.advertise-your-assets')}}.</span></h1>
                <p>{{__('website.biggest-online-advertising-marketplace')}}</p>
            </div>
        </div>
    <div class="user-form-category">
        <div class="user-form-header">
            <a href="{{route('website.index')}}">
                <img src="{{asset('website/images/logo-dark.png')}}" alt="logo"></a>
            <a href="{{route('website.index')}}">
                <i class="fas fa-arrow-left"></i>
            </a>
        </div>

        <div class="tab-pane active mt-50" id="login-tab">
            <div class="user-form-title">
                <img src="{{asset('website/images/logo-login.png')}}" alt="logo-moon" class="img-fluid mw-35 mb-5">
                <h2>{{__('website.welcome')}}!</h2>
                <p>
                    {{__('website.please-enter-phone')}}

                    <br>
                    {{__('website.take-advantage')}}

                </p>
            </div>
            <form action="{{route('website.submit.verify')}}" method="post">
                @csrf
                <div class="row">
                    <div class="col-3">
                        <div class="form-group">
                            <input type="text" pattern="[0-9]*" inputmode="numeric" id="C1" autofocus required oninput='digitValidate(this)' onkeyup='tabChange(1)' maxlength=1 class="form-control otp-input"></div>
                    </div>
                    <div class="col-3">
                        <div class="form-group">
                            <input type="text" pattern="[0-9]*" inputmode="numeric" id="C2" required oninput='digitValidate(this)' onkeyup='tabChange(2)' maxlength=1 class="form-control otp-input"></div>
                    </div>
                    <div class="col-3">
                        <div class="form-group">
                            <input type="text" pattern="[0-9]*" inputmode="numeric" id="C3" required oninput='digitValidate(this)' onkeyup='tabChange(3)' maxlength=1 class="form-control otp-input"></div>
                    </div>
                    <div class="col-3">
                        <div class="form-group">
                            <input type="text" pattern="[0-9]*" inputmode="numeric" id="C4" required oninput='digitValidate(this)' onkeyup='tabChange(4)' maxlength=1 class="form-control otp-input"></div>
                    </div>
                    <input type="hidden" id="cNum" name="code"  value=""  />
                    <input type="hidden" id="cNum" name="phone"  value="{{$phone}}"  />

                    <div class="col-12">
                        <div class="form-group">
                            <button  class="btn btn-inline">{{__('website.verify-now')}}</button>
                        </div>
                    </div>
                </div>

            </form>

        </div>

    </div>
</section>

@endsection
@section('extra-js')
    <script>
        let digitValidate = function(ele){
            console.log(ele.value);
            ele.value = ele.value.replace(/[^0-9]/g,'');
        }

        let tabChange = function(val){
            let ele = $("input[id^=C]");
            if(ele[val-1].value != '' && val!=4) {
                ele[val].focus()
            }
            // }else if(ele[val].value == '' && val!=4){
            //     ele[val-1].focus()
            // }
            var str = "";
            $("input[id^=C]").each(function(index) {
                str = str + $(this).val();
                console.log('index'+index);
            });

            $("#cNum").val(str);

        }

    </script>

@endsection
