<footer class="footer-part">
    <div class="container">
        <div class="row newsletter">
            <div class="col-lg-6">
                <div class="news-content">
                    <h2>{{__('website.Subscribe for Latest Offers')}}</h2>
                    <p>{{__('website.Buy and sell everything from used cars to mobile phones and computers, or search for property, jobs and more in the world with moon')}}
                        .

                    </p>
                </div>
            </div>
            <div class="col-lg-6">
                <form class="news-form" action="{{route('website.contact-us-submit')}}" method="post">
                    @csrf
                    <input type="hidden" name="type" value="1">
                    <input type="email" name="email" placeholder="{{__('website.enter-your-email-address')}}">
                    <button class="btn btn-inline" type="submit">
                        <i class="fas fa-envelope"></i>
                        <span>{{__('website.subscribe')}}</span>
                    </button>
                    @if(Session::has('success-contact'))

                        <div class="alert alert-success alert-dismissible">
                            <a href="#" class="close" data-dismiss="alert" aria-label="close">&times;</a>
                            <strong>{{__('website.email')}}!</strong> {{Session::get('success')}}.
                        </div>
                    @endif

                </form>
            </div>
        </div>
        <div class="row">
            <div class="col-sm-6 col-md-6 col-lg-3">
                <div class="footer-content">
                    <h3>{{__('website.contact-us')}}</h3>
                    <ul class="footer-address">
                        <li><i class="fas fa-map-marker-alt"></i>
                            <p> {{$settings[\App\Helpers\Constant::SETTING_KEYS['Address']]->content}}</p>

                        </li>
                        <li><i class="fas fa-envelope"></i>
                            <a class="phone"
                               href="mailto:Info@moon4online.com">  {{$settings[App\Helpers\Constant::SETTING_KEYS['Email']]->content}} </a>
                        </li>
                        <li><i class="fas fa-phone-alt"></i>
                            <a class="phone"
                               href="tel:$phone1->title">{{$settings[\App\Helpers\Constant::SETTING_KEYS['Phone']]->content}}</a>


                        </li>
                    </ul>
                </div>
            </div>
            <div class="col-sm-6 col-md-6 col-lg-3">
                <div class="footer-content">
                    <h3>{{__('website.quick-links')}}</h3>
                    <ul class="footer-widget">
                        <li><a href="{{route('website.about')}}">{{__('website.about-moon')}}</a></li>
                            <li>
                                <a href="{{route('store.register')}}">{{__('website.be-a-shop')}}</a>
                            </li>
                            <li>
                                <a href="{{route('website.packages')}}">{{__('website.moon-pricing')}}</a>
                            </li>
                            <li>
                                <a href="{{route('website.login')}}">{{__('website.login')}}</a>
                            </li>
                            <li>
                                <a href="{{route('website.all-shops','all')}}">{{__('website.shops')}}</a>
                            </li>
                    </ul>
                </div>
            </div>
            <div class="col-sm-6 col-md-6 col-lg-3">
                <div class="footer-content">
                    <h3>{{__('website.information')}}</h3>
                    <ul class="footer-widget">
                        <li><a href="{{route('website.contact-us')}}">{{__('website.contact-us')}}</a></li>
                        <li><a href="{{route('website.help','how-to-use')}}">{{__('website.how-to-use-site')}}</a></li>
                        <li><a href="{{route('website.payment-method')}}">{{__('website.payment-method')}}</a></li>
                        <li><a href="{{route('website.safety-steps')}}">{{__('website.safety-steps')}}</a></li>
                        <li><a href="{{route('website.help','help')}}">{{__('website.help')}}</a></li>
                    </ul>
                </div>
            </div>
            <div class="col-sm-6 col-md-6 col-lg-3">
                <div class="footer-info">
                    <a href="{{route('website.index')}}">
                        <img src="{{asset('website/images/logo.png')}}" alt="moon" width="159px" height="40px" ></a>
                    <ul class="footer-count">
                        <li>
                            <h5>{{$usersCount}}</h5>
                            <p>{{__('website.registered-users')}}</p>
                        </li>
                        <li>
                            <h5>{{$advertisementsCount}}</h5>
                            <p>{{__('website.number-of-advertisements')}}</p>
                        </li>
                        <li>
                            <h5>{{$viewsCount}}</h5>
                            <p>{{__('website.number-of-views')}}</p>
                        </li>

                    </ul>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-lg-12">
                <div class="footer-card-content">
                    <div class="footer-payment">
                        <a href="{{route('website.payment-method')}}"><img src="{{asset('website/images/pay-card/01.png')}}"
                                         alt="moon" width="58px" height="38px"></a><a
                            href="{{route('website.payment-method')}}"><img src="{{asset('website/images/pay-card/02.png')}}" alt="moon" width="58px" height="38px"></a><a
                            href="{{route('website.payment-method')}}"><img
                                src="{{asset('website/images/pay-card/03.png')}}" alt="moon" width="58px" height="38px"></a><a href="{{route('website.payment-method')}}"><img
                                src="{{asset('website/images/pay-card/04.png')}}" alt="moon" width="58px" height="38px"></a></div>
                    <div class="footer-option">
                        @if(count($allCountries)>0)

                            <button type="button"  style="padding: 5px 10px; width: auto;">
                                @if(Session::has('currency')){{Session::get('currency')}} @else {{$selectedCountry->currency}} @endif
                            </button>

                            <button type="button" data-toggle="modal" data-target="#country" style="padding: 5px 10px; width: auto;"><i
                                    class="fas fa-flag"></i>@if(Session::has('country_name')){{Session::get('country_name')}} @else {{$selectedCountry->name}} @endif
                            </button>
                        @endif
                            <button class="lang" type="button" data-toggle="modal"
                                    data-target="#language"><i class="fas fa-globe"></i>{{app()->getLocale()=='en'?__('website.english'):__('website.arabic')}}</button>

                    </div>
                    <div class="footer-app"><a href="https://play.google.com/store/apps/details?id=grand.app.moon"><img src="{{asset('website/images/play-store.png')}}"
                                                             alt="play-store"
                                                             class="download-store" width="128px" height="38px"></a><a href="https://apps.apple.com/om/app/moon-user/id1548901867"><img
                                src="{{asset('website/images/app-store.png')}}"
                                alt="app-store" class="download-store" width="128px" height="38px"></a>
                        <a href="https://apkapp.gallery/dl/104477639/Moon">
                            <img src="{{asset('website/images/hawawi.png')}}" alt="hawawi" class="download-store" width="128px" height="38px"></a>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="footer-end">
        <div class="container">
            <div class="footer-end-content">
                <p>{{__('website.copy-right')}} &copy; 2022 <a
                        href="{{route('website.index')}}">{{__('website.moon')}}</a></p>
                @if(count($socialMedia)>0)
                    <ul class="footer-social">
                        @foreach($socialMedia as $social)
                            <li><a href="{{$social->content}}"><i class="fab fa-{{strtolower($social->getTranslation('en')->title)}}"></i></a></li>
                        @endforeach
                    </ul>
                @endif
            </div>
        </div>
    </div>
</footer>
<div class="modal fade" id="currency">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h4>{{__('website.Choose a Currency')}}</h4>
                <button class="fas fa-times" data-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                @foreach($allCountries->pluck('currency')->toArray() as $currency)
                    <button onclick="changeCurrency('{{$currency}}')"
                            class="modal-link
                            @if(Session::has('currency') && Session::get('currency')==$currency)
                                active
                            @elseif(!Session::has('currency') && $selectedCountry->currency==$currency)
                                active
                            @else

                            @endif">

                        {{$currency}}

                    </button>
                @endforeach
            </div>
        </div>
    </div>
</div>
<div class="modal fade" id="country">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h4>{{__('website.choose-a-country')}}</h4>
                <button class="fas fa-times" data-dismiss="modal"></button>
            </div>
            <div class="modal-body lang-body">
                @if(count($allCountries)>0)
                    @foreach($allCountries as $country)
                        <button onclick="changeCountry({{$country->id}},'{{$country->name}}')"
                                class="modal-link
                              @if(Session::has('country') && Session::get('country')==$country->id)
                                    active
                                @elseif(!Session::has('country') && $selectedCountry->name==$country->name)
                                    active
                                  @else
                                    jdjdj

                                @endif
                                    ">{{$country->name}}</button>
                    @endforeach
                @endif

            </div>
        </div>
    </div>
</div>
<div class="modal fade" id="language">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h4>{{__('website.choose-a-language')}}</h4>
                <button class="fas fa-times" data-dismiss="modal"></button>
            </div>
            <div class="modal-body lang-body">
                        <button onclick="window.location='{{route('website.change-language',['language'=>'en'])}}'"
                                class="modal-link @if(app()->getLocale()=='en')  active @endif">{{__('website.english')}}</button>
                        <button onclick="window.location='{{route('website.change-language',['language'=>'ar'])}}'"
                                class="modal-link  @if(app()->getLocale()=='ar')  active @endif">{{__('website.arabic')}}</button>

            </div>
        </div>
    </div>
</div>
@yield('extra-models')
