<header class="header-part">
    <div class="container">
        <div class="header-content">
            <div class="header-left">
                <button type="button" class="header-widget sidebar-btn"><i
                            class="fas fa-align-left"></i></button>
                <a href="{{route('website.index')}}" class="header-logo"><img
                            src="{{asset('website/images/logo.png')}}" alt="moon" width="159px" height="40px"></a>


                <div class="footer-option no-margin shops-button">
                    <button class="lang" type="button" onclick="location.href='{{route('store.register')}}'"><i class="fas fa-store"></i>{{__('website.be-a-shop')}}</button>
                </div>
            </div>
            <form class="header-form" action="{{route('website.all-advertisements','all')}}?Type='Search'" method="get">
{{--                <input type="hidden" name="type" value="Search">--}}
                <div class="header-search">
                    <button type="submit" title="Search Submit "><i
                                class="fas fa-search"></i></button>
                    <input type="text"
                           placeholder="{{__('website.search-text')}}" value="{{request()->text??old('text')}}" name="text">
                    <button type="button" title="Search Option"
                            class="option-btn"><i class="fas fa-sliders-h"></i></button>
                </div>
                <div class="header-option">
                    <div class="option-grid">
                        <div class="option-group">
                            <select name="city_id[]">
                                <option label="{{__('website.select-city')}}"></option>
                                @if(count($cities))
                                    @foreach($cities as $city)
                                        <option value="{{$city->id}}">{{$city->name}}</option>
                                    @endforeach
                                @endif
                            </select>
                        </div>
                        <div class="option-group">
                            <select name="category_id[]" onchange="selectSubCategory(this.options[this.selectedIndex].value)">

                                <option label="{{__('website.select-category')}}"></option>

                                @if(count($categories))
                                    @foreach($categories as $category)
                                        <option value="{{$category->id}}">{{$category->name}}</option>
                                    @endforeach
                                @endif
                            </select>
                        </div>
                        <div class="option-group" id="select-sub-div">
                            <select name="sub_category_id[]" id="select-sub-category" disabled >

                                <option label="{{__('website.select-sub-category')}}"></option>

                            </select>
                        </div>
                        <div class="option-group">
                            <select name="sortBy">
                                <option label="{{__('website.sort-by')}}"></option>
                                <option value="rated" >{{__('website.most-rated')}}</option>
                                <option value="price">{{__('website.price')}}</option>
                                <option value="date">{{__('website.date')}}</option>
                            </select>
                        </div>
                        <div class="option-group"><input type="text" min="{{$minPrice}}" name="min_price"
                                                         placeholder="{{__('website.min-price',['Min-price'=>$minPrice])}}">
                        </div>
                        <div class="option-group"><input type="text" max="{{$maxPrice}}" name="max_price"
                                                         placeholder="{{__('website.max-price',['Max-price'=>$maxPrice])}}">
                        </div>
                        <button
                                type="submit"><i class="fas fa-search"></i><span>{{__('website.search')}}</span>
                        </button>
                    </div>
                </div>

            </form>
            <div class="header-right">
                @if(auth()->user())
                    <ul class="header-list">
                        <li class="header-item"><a href="{{route('website.favorites')}}" class="header-widget"><i
                                        class="fas fa-heart"></i><sup id="favorite-count">{{auth()->user()?count($favorites):$favorites}}</sup></a></li>
                        <li class="header-item">
                            <button type="button" class="header-widget">
                                <i class="fas fa-bell"></i><sup>0</sup>
                            </button>
                            <div class="dropdown-card">
                                <div class="dropdown-header">
                                    <h5>Notification (1)</h5>
                                    <a href="{{route('website.notifications')}}">{{__('website.view-all')}}</a>
                                </div>
                                <ul class="notify-list">
                                    @if(count($notifications))
                                        @foreach($notifications->take(5) as $notification)
                                            <li class="notify-item @if($notification->seen==0)active @endif">
                                                @if($notification->type==\App\Helpers\Constant::NOTIFICATION_TYPE['Store'])
                                                    <a href="{{route('website.shop-details',['id'=>$notification->action_by_id,'slug'=>$notification->store->slug])}}"
                                                       class="notify-link">
                                                        <div class="notify-img"><img
                                                                    src="{{$notification->store->image()?$notification->store->image():'website/images/favicon.png'}}"
                                                                    alt="avatar"></div>
                                                        <div class="notify-content">
                                                            <p class="notify-text">
                                                                <span>{{$notification->store->name}}</span><br>
                                                                {{$notification->text}}</span></p>
                                                            <span class="notify-time">{{$notification->created_at}}</span>
                                                        </div>
                                                    </a>
                                                @elseif($notification->type==\App\Helpers\Constant::NOTIFICATION_TYPE['Advertisement'])
                                                    <a href="{{route('website.advertisement-details',['id'=>$notification->action_by_id,'slug'=>$notification->advertisement->slug])}}"
                                                       class="notify-link">
                                                        <div class="notify-img"><img
                                                                    src="{{$notification->advertisement->image()?$notification->advertisement->image():'website/images/favicon.png'}}"
                                                                    alt="avatar"></div>
                                                        <div class="notify-content">
                                                            <p class="notify-text">
                                                                <span>{{$notification->advertisement->title}}</span><br>
                                                                {{$notification->text}}
                                                            </p>
                                                            <span class="notify-time">{{$notification->created_at}}</span>
                                                        </div>
                                                    </a>

                                                @else
                                                    <a href="javascript:void(0)" class="notify-link">
                                                        <div class="notify-img"><img
                                                                    src="{{\App\Models\Setting::where('key',\App\Helpers\Constant::SETTING_KEYS['Logo'])->first()?getImage(\App\Models\Setting::where('key',\App\Helpers\Constant::SETTING_KEYS['Logo'])->first()->image):'website/images/favicon.png'}}"
                                                                    alt="avatar"></div>
                                                        <div class="notify-content">
                                                            <p class="notify-text">
                                                                <span>{{__('website.admin')}}</span><br>
                                                                {{$notification->text}}
                                                            </p>
                                                            <span class="notify-time">{{$notification->created_at}}</span>
                                                        </div>
                                                    </a>


                                                @endif
                                            </li>
                                        @endforeach
                                    @endif
                                </ul>
                            </div>
                        </li>
                    </ul>
                @else
                    <ul class="header-list">
                        <li class="header-item">
                            <a href="{{route('website.login')}}" class="header-widget">
                                <i class="fas fa-heart"></i><sup>0</sup></a></li>
                        <li class="header-item">
                            <a href="{{route('website.login')}}" class="header-widget">
                                <i class="fas fa-bell"></i><sup>0</sup></a>
                        </li>
                    </ul>

                @endif
                @if(!auth()->user())

                    <a href="{{route('website.login')}}" class="btn btn-inline post-btn"> <i class="far fa-user"></i>
                        <span> {{__('website.login')}} </span></a>
                @else
                    <a href="{{route('website.profile',auth()->id())}}" class="btn btn-inline post-btn"> <i
                                class="far fa-user"></i>
                        <span> {{__('website.my-profile')}} </span></a>

                @endif
            </div>

        </div>
    </div>
</header>
<aside class="sidebar-part">
    <div class="sidebar-body">
        <div class="sidebar-header"><a href="{{route('website.index')}}" class="sidebar-logo"><img
                        src="{{asset('website/images/logo.png')}}"
                        alt="logo"></a>
            <button class="sidebar-cross"><i class="fas fa-times"></i></button>
        </div>
        <div class="sidebar-content">
            @if(auth()->user())
                <div class="sidebar-profile">
                    <a href="{{route('website.profile',auth()->id())}}" class="sidebar-avatar"><img
                                src="{{auth()->user()->image()?auth()->user()->image():asset('/website/images/avatar/profile-default.png')}}"
                                alt="avatar"></a>
                    <h4>
                        <a href="{{route('website.profile',auth()->id())}}"
                           class="sidebar-name">{{auth()->user()->name}}</a></h4>
                </div>
            @else
                <div class="sidebar-profile">
                    <a class="sidebar-avatar"><img
                                src="{{asset('/website/images/avatar/profile-default.png')}}"
                                alt="avatar"></a>
                    <h4>
                        <a class="sidebar-name">{{__('website.username')}}</a></h4>
                </div>

            @endif
            <div class="sidebar-menu">
                <ul class="nav nav-tabs">
                    <li><a href="#main-menu" class="nav-link active" data-toggle="tab">{{__('website.main-menu')}}</a>
                    </li>

                        <li><a href="#author-menu" class="nav-link" data-toggle="tab">{{__('website.profile')}} </a>
                        </li>

                </ul>
                <div class="tab-pane active" id="main-menu">
                    <ul class="navbar-list">
                        <li class="navbar-item"><a class="navbar-link"
                                                   href="{{route('website.index')}}">{{__('website.home')}}</a></li>
                        <li class="navbar-item"><a class="navbar-link"
                                                   href="{{route('website.view-all-explores')}}">{{__('website.explore')}}</a>
                        </li>
                        <li class="navbar-item"><a class="navbar-link"
                                                   href="{{route('website.about')}}">{{__('website.about-moon')}}</a>
                        </li>
                        <li class="navbar-item"><a class="navbar-link"
                                                   href="{{route('website.shops-on-map')}}"> {{__('website.moon-map')}}</a>
                        </li>

                        <li class="navbar-item"><a class="navbar-link"
                                                   href="{{route('website.all-shops','all')}}">{{__('website.shops')}}</a>
                        </li>
                        <li class="navbar-item navbar-dropdown"><a class="navbar-link"
                            ><span>{{__('website.categories')}}</span><i
                                        class="fas fa-plus"></i></a>
                            <ul class="dropdown-list">

                                @foreach($categories as $category)
                                    <li><a class="dropdown-link"
                                           href="{{route('website.all-advertisements',$category->slug)}}?type=View">{{$category->name}}</a>
                                    </li>
                                @endforeach

                            </ul>
                        </li>
                        <li class="navbar-item"><a class="navbar-link"
                                                   href="{{route('website.packages')}}">{{__('website.moon-pricing')}}</a>
                        </li>
                        <li class="navbar-item"><a class="navbar-link"
                                                   href="{{route('website.view-all-blogs')}}">{{__('website.blogs')}}</a>
                        </li>

                        <li class="navbar-item"><a class="navbar-link"
                                                   href="{{route('website.contact-us')}}">{{__('website.contact-us')}}</a>
                        </li>
                        <li class="navbar-item"><a class="navbar-link"
                                                   href="{{route('website.terms')}}">{{__('website.terms-and-conditions')}}</a>
                        </li>
                        <li class="navbar-item"><a class="navbar-link"
                                                   href="{{route('website.help','how-to-use')}}">{{__('website.how-to-use')}} {{__('website.moon')}}</a>
                        </li>
                        <li class="navbar-item"><a class="navbar-link"
                                                   href="{{route('website.help','help')}}">{{__('website.help')}}</a>
                        </li>
                        <li class="navbar-item"><a class="navbar-link"
                                                   href="{{route('store.register')}}">{{__('website.register-as-shop')}}</a>
                        </li>
                        @if(app()->getLocale()=='ar')
                        <li class="navbar-item"><a class="navbar-link"
                                                   href="{{route('website.change-language',['language'=>'en'])}}">{{__('website.change-language')}}</a>
                        </li>
                        @else
                            <li class="navbar-item"><a class="navbar-link"
                                                       href="{{route('website.change-language',['language'=>'ar'])}}">{{__('website.change-language')}}</a>

                        @endif
                    </ul>
                </div>
                @if(auth()->user())
                    <div class="tab-pane" id="author-menu">
                        <ul class="navbar-list">
                            <li class="navbar-item"><a class="navbar-link"
                                                       href="{{route('website.profile',auth()->id())}}">{{__('website.edit-profile')}}</a>
                            </li>
                            <li class="navbar-item"><a class="navbar-link"
                                                       href="{{route('website.last-seen-ads')}}">{{__('website.last-seen-ads')}}</a>
                            </li>
                            <li class="navbar-item"><a class="navbar-link"
                                                       href="{{route('website.followed-shops')}}">{{__('website.followed-shops')}}</a>
                            </li>
                            {{--                        <li class="navbar-item"><a class="navbar-link" href="connected-whatsapp.html">whatsapp connected--}}
                            {{--                                shops</a></li>--}}
                            <li class="navbar-item"><a class="navbar-link"
                                                       href="{{route('website.blocked-shops')}}">{{__('website.blocked-shops')}}</a>
                            </li>
                            <li class="navbar-item"><a class="navbar-link"
                                                       href="{{route('website.last-search')}}">{{__('website.last-search')}}</a>
                            </li>
                            <li class="navbar-item navbar-dropdown"><a class="navbar-link"
                                                                       href="{{route('website.favorites')}}"><span>{{__('website.favorites')}}</span><span>{{auth()->user()?count($favorites):$favorites}}</span></a>
                            </li>
                            <li class="navbar-item navbar-dropdown"><a class="navbar-link"
                                                                       href="{{route('website.notifications')}}"><span>{{__('website.notifications')}}</span><span>{{auth()->user()?auth()->user()->notification_count:0}}</span></a>
                            </li>
                            <li class="navbar-item"><a class="navbar-link"
                                                       href="{{route('website.logout')}}">{{__('website.logout')}}</a>
                            </li>
                        </ul>
                    </div>
                @else
                    <div class="tab-pane" id="author-menu">
                        <ul class="navbar-list">
                            <li class="navbar-item"><a class="navbar-link"
                                                       href="{{route('website.login')}}">{{__('website.edit-profile')}}</a>
                            </li>
                            <li class="navbar-item"><a class="navbar-link"
                                                       href="{{route('website.login')}}">{{__('website.last-seen-ads')}}</a>
                            </li>
                            <li class="navbar-item"><a class="navbar-link"
                                                       href="{{route('website.login')}}">{{__('website.followed-shops')}}</a>
                            </li>
                            {{--                        <li class="navbar-item"><a class="navbar-link" href="connected-whatsapp.html">whatsapp connected--}}
                            {{--                                shops</a></li>--}}
                            <li class="navbar-item"><a class="navbar-link"
                                                       href="{{route('website.login')}}">{{__('website.blocked-shops')}}</a>
                            </li>
                            <li class="navbar-item"><a class="navbar-link"
                                                       href="{{route('website.login')}}">{{__('website.last-search')}}</a>
                            </li>
                            <li class="navbar-item navbar-dropdown"><a class="navbar-link"
                                                                       href="{{route('website.login')}}"><span>{{__('website.favorites')}}</span><span>{{auth()->user()?count($favorites):$favorites}}</span></a>
                            </li>
                            <li class="navbar-item navbar-dropdown"><a class="navbar-link"
                                                                       href="{{route('website.login')}}"><span>{{__('website.notifications')}}</span><span>{{auth()->user()?auth()->user()->notification_count:0}}</span></a>
                            </li>
                            <li class="navbar-item"><a class="navbar-link"
                                                       href="{{route('website.login')}}">{{__('website.login')}}</a>
                            </li>
                        </ul>
                    </div>

                @endif
            </div>
            <div class="sidebar-footer">
                <p>{{__('website.copy-right')}} <a href="{{route('website.index')}}">{{__('website.moon')}}</a></p>

            </div>
        </div>
    </div>
</aside>
<nav class="mobile-nav">
    <div class="container">
        <div class="mobile-group">
            <a href="{{route('website.index')}}" class="mobile-widget"><i
                        class="fas fa-home"></i><span>{{__('website.home')}}</span></a>
            @if(auth()->user())
                <a href="{{route('website.profile',auth()->id())}}"
                   class="mobile-widget"><i
                            class="fas fa-user"></i><span>{{__('website.profile')}}</span></a>
                <a
                        href="{{route('website.notifications')}}" class="mobile-widget"><i
                            class="fas fa-bell"></i><span>{{__('website.notifications')}}</span><sup>0</sup></a>

            @else
                <a href="{{route('website.login')}}" class="mobile-widget"><i
                            class="fas fa-user"></i><span>{{__('website.profile')}}</span></a>
                <a
                        href="{{route('website.login')}}" class="mobile-widget"><i
                            class="fas fa-bell"></i><span>{{__('website.notifications')}}</span><sup>0</sup></a>

            @endif
        </div>
    </div>
</nav>
