@extends('Website.layouts.app',['title'=>__('website.moon').' : '.$advertisement->id.' : '.$advertisement->city->name.' : '.$advertisement->subcategory->category->name.' : '.$advertisement->subcategory->name.' : '.$advertisement->title
,'description'=>__('website.advertisement-number').' : '.$advertisement->id.' '.(strlen($advertisement->description) > 160) ? substr($advertisement->description,0,160) : $advertisement->description])
@section('extra-css')
    <link rel="stylesheet" href="{{app()->getLocale()=='en'?asset('website/css/custom/ad-details.css'):asset('website/css/custom/ad-details-rtl.css')}}">


@endsection
@section('page-title')
    {{$advertisement->title}}
@endsection
@section('meta-deep-link')


    <link rel="icon" href="{{$advertisement->image()}}" type="image/x-icon">
    <link rel="shortcut icon" href="{{$advertisement->image()}}" type="image/x-icon">

    <meta property="og:title" content="{{$advertisement->title}}">
    <meta property="og:type" content="website">
    <meta property="og:url" content="{{Request::fullUrl()}}">
    <meta property="og:site_name" content="{{Request::url()}}">
    <meta property="og:description" content="{{$advertisement->description}}">
    <meta property="og:image"  itemprop="image" content="{{$advertisement->image()}}">
    <meta property="og:image:secure_url"  itemprop="image" content="{{$advertisement->image()}}">
    <meta property="og:image:width" content="400" />
    <meta property="og:image:height" content="300" />
    <meta property="og:image:type" content="image/webp" />
    <meta property="og:image:alt" content="{{$advertisement->title}}">

    <meta property="og:updated_time" content="1440432930" />

    <meta property="twitter:title" content="{{$advertisement->title}}">
    <meta property="twitter:card" content="summary_large_image">
    <meta property="twitter:description" content="{{$advertisement->description}}">
    <meta property="twitter:site" content="@moon">
    <meta property="twitter:creator" content="@moon">
    <meta property="twitter:image" content="{{$advertisement->image()}}">
    <meta property="twitter:image:alt" content="{{$advertisement->title}}">
@endsection
@section('banner')
    <section class="single-banner">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <div class="single-content">
                        <h1>{{$advertisement->title}}</h1>
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="{{route('website.index')}}">{{__('website.home')}}</a>
                            </li>
                            <li class="breadcrumb-item"><a
                                    href="{{route('website.all-advertisements',$advertisement->subCategory->category->slug)}}?type=View">{{$advertisement->subCategory->category->name}}</a>
                            </li>
                            <li class="breadcrumb-item"><a
                                    href="{{route('website.all-advertisements',$advertisement->subCategory->slug)}}?type=View">{{$advertisement->subCategory->name}}</a>
                            </li>

                            <li class="breadcrumb-item active" aria-current="page">{{$advertisement->title}}</li>
                        </ol>
                    </div>
                </div>
            </div>
        </div>
    </section>

@endsection
@section('content')
    <section class="inner-section ad-details-part">
        <div class="container">
            <div class="row content-reverse">
                <div class="col-lg-4">
                    <div class="common-card price hidden-small-2">
                        <h3>  {{$advertisement->price}} {{$advertisement->city->country->currency}}
                            <span> / @if($advertisement->is_negotiable==0) {{__('website.negotiable')}} @else {{__('website.not-negotiable')}} @endif </span>
                        </h3><i class="fas fa-tag"></i>
                    </div>
                    <button type="button" class="common-card number hidden-small-2" data-toggle="modal"
                            data-target="#number">
                        <h3>({{substr($advertisement->shop->phone, 0, 3)}})<span>{{__('website.click-to-show')}}</span>
                        </h3><i
                            class="fas fa-phone"></i>
                    </button>
                    <div class="common-card">
                        <div class="card-header">
                            <h5 class="card-title">{{__('website.shop-info')}}</h5>
                        </div>
                        <div class="ad-details-author"><a
                                href="{{route('website.shop-details',['id'=>$advertisement->shop->id,'slug'=>$advertisement->shop->slug])}}"
                                class="author-img active"><img
                                    src="{{$advertisement->shop->image()}}" alt="{{$advertisement->shop->name}}"></a>
                            <div class="author-meta">
                                <h4>
                                    <a href="{{route('website.shop-details',['id'=>$advertisement->shop->id,'slug'=>$advertisement->shop->slug])}}">{{$advertisement->shop->name}}</a>
                                </h4>
                                <h5>{{__('website.joined')}} : {{\Carbon\Carbon::createFromTimeStamp(strtotime($advertisement->shop->created_at))->diffForHumans()}}</h5>
                                <p>{{$advertisement->shop->description}}</p>
                            </div>
                            <div class="author-widget"><a
                                    href="{{route('website.shop-details',['id'=>$advertisement->shop->id,'slug'=>$advertisement->shop->slug])}}"
                                    title="{{__('website.shop-details')}}" class="fas fa-eye"></a>
{{--                                <a--}}
{{--                                    href="javascript:void(0)" title="Message" class="fas fa-envelope"></a>--}}
                                @if(auth()->user())
                                    <button
                                        type="button" title="{{__('website.follow')}}" id="follow-icon" class="follow fas fa-users @if($advertisement->is_follow==1)  active @endif"

                                        onclick="follow({{$advertisement->shop->id}})">

                                    </button>
                                @endif
                                <button
                                    type="button" title="{{__('website.number')}}" class="fas fa-phone" data-toggle="modal"
                                    data-target="#number"></button>
                                <button type="button" title="{{__('website.share')}}"
                                        class="fas fa-share-alt" data-toggle="modal"
                                        data-target="#profile-share"></button>
                            </div>
                            <ul class="author-list">
                                <li>
                                    <h6>{{__('website.ads')}}</h6>
                                    <p>{{$advertisement->shop->advertisements_count}}</p>
                                </li>
                                <li>
                                    <h6>{{__('website.rates')}}</h6>
                                    <p>{{$advertisement->shop->average_rate}}</p>
                                </li>
                                <li>
                                    <h6>{{__('website.followers')}}</h6>
                                    <p>{{$advertisement->shop->followers_count}}</p>
                                </li>
                            </ul>
                        </div>
                    </div>
                        <div class="common-card">
                            <div class="card-header">
                                <h5 class="card-title">{{__('website.safety-tips')}}</h5>
                            </div>
                            <div >
                                    {!! $safetyTips->content !!}

                            </div>
                        </div>
                    <div class="common-card">
                        <div class="card-header">
                            <h5 class="card-title">{{__('website.working-hours')}}</h5>
                        </div>
                        <ul class="ad-details-opening">
                            @if(count($advertisement->shop->working_hours)>0)
                                @foreach($advertisement->shop->working_hours as $key=>$workingHour)
                                    <li>
                                        <h6>{{\Carbon\Carbon::now()->addDays($key)->format('l')}}</h6>
                                        @if($workingHour->status==true)
                                            <p>{{$workingHour->from}} - {{$workingHour->to}}</p>
                                        @else
                                            <p>{{__('website.closed')}}</p>
                                        @endif
                                    </li>
                                @endforeach
                            @endif
                        </ul>
                    </div>
                    <div class="common-card">
                        <div class="card-header">
                            <h5 class="card-title">{{__('website.shop-location')}}</h5>
                        </div>
                        <iframe class="ad-details-map"
                                src="https://maps.google.com/maps?q='+{{$advertisement->shop->latitude}}+','+{{$advertisement->shop->longitude}}+'&hl=es&z=14&amp;output=embed">
                        </iframe>

                        <button class="btn btn-primary btn-block" type="button" data-toggle="modal"
                                data-target="#location-share"><i class="fas fa-share-alt"></i>share
                        </button>
                    </div>

{{--                    <div class="common-card">--}}
{{--                        <div class="card-header">--}}
{{--                            <h5 class="card-title">{{__('website.google-ads')}}</h5>--}}
{{--                        </div>--}}
{{--                        <img src="{{asset('website/images/ads.jpg')}}" class="img-fluid">--}}
{{--                    </div>--}}
                </div>
                <div class="col-lg-8">
                    <div class="common-card">
                        <ol class="breadcrumb ad-details-breadcrumb">
                            <li><span class="flat-badge rent">@if($advertisement->premium==1){{__('website.premium')}} @else {{__('website.regular')}} @endif</span></li>

                        </ol>
                        <h6 class="ad-details-address"><i class="fas fa-clock"></i> {{\Carbon\Carbon::createFromTimeStamp(strtotime($advertisement->created_at))->diffForHumans()}}</h6>
                        <h3 class="ad-details-title">{{$advertisement->title}} </h3>
                        <div class="ad-details-meta">
                            <a class="view mb-5-mobile"><i
                                    class="fas fa-eye"></i><span><strong>({{$advertisement->views_count}})</strong>{{__('website.preview')}}</span></a><a
                                 class="click mb-5-mobile"><i class="fas fa-heart"></i><span>(<strong id="ad-favorite-count">{{$advertisement->favorite_count}}</strong>){{__('website.favorite-count')}}</span></a><a
                                class="rating mb-5-mobile"><i
                                    class="fas fa-star"></i><span><strong>({{$advertisement->rate_count}})</strong>{{__('website.review')}}</span></a>
                            <a  class="view share-number"><i
                                    class="fas fa-share-alt"></i><span><strong>({{$advertisement->share_count}})</strong>{{__('website.shares')}}</span></a>
                        </div>
                        @if(count($advertisement->images())>0)
                            <div class="ad-details-slider-group">
                                <div class="ad-details-slider slider-arrow">
                                    @foreach($advertisement->images() as $image)
                                        <div><img src="{{$image}}" alt="{{$advertisement->title}}"></div>
                                    @endforeach
                                </div>
                                <div class="cross-vertical-badge ad-details-badge"><i
                                        class="fas fa-clipboard-check"></i><span>recommend</span></div>
                            </div>
                            <div class="ad-thumb-slider">
                                @foreach($advertisement->images() as $image)
                                    <div><img src="{{$image}}" alt="{{$advertisement->title}}"></div>
                                @endforeach
                            </div>
                        @endif

                        <ul class="call-mobile d-lg-none d-md-none">
                            <li>
                                <div class="common-card price">
                                    <h3> {{$advertisement->price}} {{$advertisement->city->country->currency}}</h3><i class="fas fa-tag"></i>
                                </div>
                            </li>
                            <li>
                                <button type="button" class="common-card number" data-toggle="modal"
                                        data-target="#number">
                                    <h3>(+{{substr($advertisement->shop->phone, 0, 4)}}
                                        )<span>{{__('website.click-to-show')}}</span></h3><i class="fas fa-phone"></i>


                                </button>
                            </li>
                        </ul>
                        <div class="ad-details-action">
                            @if(auth()->user())
                                <button type="button"
                                        onclick="favorite({{$advertisement->id}})"
                                        class="wish @if($advertisement->is_favorite==1) active @endif" id="favorite{{$advertisement->id}}"><i
                                        class="fas fa-heart"></i>{{__('website.bookmark')}}</button>
                            @endif
                            <button type="button" data-toggle="modal" data-target="#ad-share"><i
                                    class="fas fa-share-alt"></i>{{__('website.share')}}
                            </button>
                            <button class="report-button" type="button" data-toggle="modal"
                                    data-target="#report"><i
                                    class="fas fa-exclamation-triangle"></i>{{__('website.report')}}</button>
{{--                            <button class="block-button" type="button" data-toggle="modal" data-target="#block"><i--}}
{{--                                    class="fas fa-ban"></i>{{__('website.block')}}</button>--}}
                        </div>
                    </div>
                    @if(count($advertisement->properties)>0)
                        <div class="common-card">
                            <div class="card-header">
                                <h5 class="card-title">{{__('website.specifications')}}</h5>
                            </div>
                            <ul class="ad-details-specific">
                                @foreach($advertisement->properties as $property )
                                    <li>
                                        <h6>{{$property->name}}</h6>
                                        @if($property->parent)
                                            <p>{{$property->parent->name}}</p>
                                        @else
                                            <p>{{$property->pivot->text}}</p>
                                        @endif

                                    </li>
                                @endforeach
                            </ul>
                            <div class="modal-share mt-3">
                                <a href="https://www.facebook.com/sharer.php?u={{route('website.advertisement-details',['id'=>$advertisement->id,'slug'=>$advertisement->slug])}}?type=View" target="_blank">
                                    <i class="facebook fab fa-facebook-f"></i><span>{{__('website.facebook')}}</span></a>
                                <a href="https://twitter.com/intent/tweet?text={{$advertisement->title}}&url={{route('website.advertisement-details',['id'=>$advertisement->id,'slug'=>$advertisement->slug])}}?type=View" target="_blank"><i
                                        class="twitter fab fa-twitter"></i><span>{{__('website.twitter')}}</span></a>
                                <a href="https://api.whatsapp.com/send/?phone={{$advertisement->shop->phone}}&text={{__('website.chatting-for-text').route('website.advertisement-details',['id'=>$advertisement->id,'slug'=>$advertisement->slug])}}?type=View&app_absent=0" target="_blank"><i
                                        class="whatsapp-social fab fa-whatsapp"></i><span>{{__('website.whats-app')}}</span></a>
                                <a href="javascript:myFunction('{{route('website.advertisement-details',['id'=>$advertisement->id,'slug'=>$advertisement->slug])}}');"
                                   id="copy-link"><i
                                        class="link fas fa-link"></i><span>{{__('website.copy-link')}}</span></a></div>
                        </div>
                    @endif
                    <div class="common-card">
                        <div class="card-header">
                            <h5 class="card-title">{{__('website.description')}}</h5>
                        </div>
                        <p class="ad-details-desc">{{$advertisement->description}}</p>
                    </div>
                    <div class="common-card" id="review">
                        <div class="card-header">
                            <h5 class="card-title">{{__('website.reviews')}} ({{$advertisement->rate_count}})</h5>
                        </div>
                        <div class="ad-details-review">
                            @if(count($advertisement->reviews)>0)
                                <ul class="review-list">
                                    @foreach($advertisement->reviews as $review)
                                        <li class="review-item">
                                            <div class="review-user">
                                                <div class="review-head">
                                                    <div class="review-profile">
                                                        <a href="#" class="review-avatar">
                                                            <img src="{{$review->user->image()}}" alt="review"></a>
                                                        <div class="review-meta">
                                                            <h6>
                                                                <a href="#">{{$review->user->name}}</a><span>{{$review->created_at}}</span>
                                                            </h6>
                                                            <ul>

                                                                @for($i=0; $i<$review->rate;$i++)
                                                                    <li><i class="fas fa-star active"></i></li>
                                                                @endfor
                                                                @if($review->rate<5)
                                                                    @for($i=0; $i<(5-$review->rate);$i++)
                                                                        <li><i class="fas fa-star "></i></li>
                                                                    @endfor
                                                                @endif


                                                            </ul>
                                                        </div>
                                                    </div>
                                                </div>
                                                <p class="review-desc">{{$review->review}}</p>
                                            </div>
                                        </li>
                                    @endforeach
                                </ul>
                            @endif
                            @if(auth()->user())
                                <div class="form-title">
                                    <h3>{{__('website.leave-your-comment')}}</h3>
                                </div>
                                <form class="review-form" action="{{route('website.add-comment')}}" method="POST">
                                    @csrf
                                    <input type="hidden" name="advertisement_id" value="{{$advertisement->id}}">
                                    <div class="star-rating">
                                        <input type="checkbox" value="5" name="rate" id="star-1">
                                        <label for="star-1"></label>
                                        <input type="checkbox" value="4" name="rate" id="star-2">
                                        <label for="star-2"></label>
                                        <input type="checkbox" value="3" name="rate" id="star-3">
                                        <label for="star-3"></label>
                                        <input type="checkbox" value="2" name="rate" id="star-4">
                                        <label for="star-4"></label>
                                        <input type="checkbox" value="1" name="rate" id="star-5">
                                        <label for="star-5"></label>
                                    </div>

                                    <div class="form-group">
                                        <textarea name="review" class="form-control"
                                                  placeholder="{{__('website.review')}}"></textarea>
                                    </div>
                                    <button type="submit" class="btn btn-inline review-submit">
                                        <span>{{__('website.write-comment')}}</span></button>
                                </form>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    @if(count($relatedShops)>0)
        <section class="inner-section related-part mb-20">
            <div class="container">
                <div class="row">
                    <div class="col-lg-12">
                        <div class="section-center-heading">
                            <h2> {{__('website.related')}} <span> {{__('website.shops')}} </span></h2>
                            <p>
                                {{__('website.related-shops-text')}}
                            </p>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-lg-12">
                        <div class="recomend-slider slider-arrow">
                            @foreach($relatedShops as $shop)
                                <div class="product-card ">
                                    <div class=" product-card-no-shaddow">
                                        <div class="product-img">
                                            <a href="{{route('website.shop-details',['id'=>$shop->id,'slug'=>$shop->slug])}}">
                                                <img src="{{$shop->image()}}" alt="{{$shop->name}}"></a></div>

                                    </div>
                                    <div class="product-content">
                                        <ol class="breadcrumb product-category">
                                            <li><i class="fas fa-tags"></i></li>
                                            @foreach($shop->categories()->take(4)->get() as $category)
                                                <li class="breadcrumb-item"><a
                                                        href="{{$category->slug}}">{{$category->name}}</a></li>
                                            @endforeach

                                        </ol>
                                        <h5 class="product-title"><a
                                                href="{{route('website.shop-details',['id'=>$shop->id,'slug'=>$shop->slug])}}">{{$shop->name}}</a>
                                        </h5>
                                        <div class="product-meta"><span><i class="fas fa-eye"></i>100 {{__('website.views')}}</span><span><i
                                                    class="fas fa-bullhorn"></i>{{$shop->advertisements_count}} {{__('website.ads')}}</span>
                                        </div>

                                        <button type="submit"  onclick="follow({{$shop->id}})"
                                                class="btn btn-inline @if($shop->is_follow==0) btn-secondary @endif post-btn follow-btn mb-2 "  id="follow-{{$shop->id}}">
                                            @if($shop->is_follow==0)
                                                <i class="fas fa-user"></i>
                                                <span>
                                                    {{__('website.follow')}}
                                                </span>

                                            @else
                                                <i class="fas fa-user-times"></i>
                                                <span>
                                                    {{__('website.un-follow')}}
                                                </span>

                                            @endif
                                        </button>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    </div>
                </div>

            </div>
        </section>
    @endif
    @if(count($relatedAdvertisements)>0)
        <section class="inner-section related-part ">
            <div class="container">
                <div class="row">
                    <div class="col-lg-12">
                        <div class="section-center-heading">
                            <h2> {{__('website.related')}} <span>{{__('website.ads')}}</span></h2>
                            <p>
                                {{__('website.related-ads-text')}}
                            </p>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-lg-12">
                        <div class="recomend-slider slider-arrow">
                            @foreach($relatedAdvertisements as $relatedAdvertisement)
                                <div class="product-card">
                                    <div class="product-media">
                                        <a href="{{route('website.advertisement-details',['id'=>$relatedAdvertisement->id,'slug'=>$relatedAdvertisement->slug])}}">
                                            <div class="product-img"><img src="{{$relatedAdvertisement->image()}}"
                                                                          alt="product"></div>
                                        </a>
                                        <div class="cross-vertical-badge product-badge"><i
                                                class="fas fa-clipboard-check"></i><span>{{__('website.recommend')}}</span>
                                        </div>
                                        <div class="product-type"><span
                                                class="flat-badge booking">@if($relatedAdvertisement->premium==1){{__('website.premium')}} @else {{__('website.regular')}} @endif</span></div>
                                        <ul class="product-action">
                                            <li class="view"><i
                                                    class="fas fa-eye"></i><span>{{$relatedAdvertisement->views_count}}</span>
                                            </li>
                                            <li class="click"><i class="fas fa-heart
"></i><span>{{$relatedAdvertisement->views_count}}</span></li>
                                            <li class="rating"><i class="fas fa-star"></i><span>{{$relatedAdvertisement->average_rate}}/5</span>
                                            </li>
                                        </ul>
                                    </div>
                                    <div class="product-content">
                                        <ol class="breadcrumb product-category">
                                            <li><i class="fas fa-tags"></i></li>
                                            <li class="breadcrumb-item"><a
                                                    href="{{$relatedAdvertisement->subCategory->slug}}">{{$relatedAdvertisement->subCategory->name}}</a>
                                            </li>
                                        </ol>
                                        <h5 class="product-title"><a
                                                href="{{route('website.advertisement-details',['id'=>$relatedAdvertisement->id,'slug'=>$relatedAdvertisement->slug])}}">{{$relatedAdvertisement->title}}</a>
                                        </h5>
                                        <div class="product-meta"><span><i class="fas fa-map-marker-alt"></i>
                                        {{$relatedAdvertisement->city->name}}</span><span><i class="fas fa-clock"></i>{{\Carbon\Carbon::createFromTimeStamp(strtotime($relatedAdvertisement->created_at))->diffForHumans()}}</span>
                                        </div>
                                        <div class="product-info">
                                            <h5 class="product-price">{{$relatedAdvertisement->price}}
                                                <span>/{{__('website.per-day')}}</span></h5>
                                            <div class="product-btn">
                                                <a href="tel:{{$relatedAdvertisement->shop->phone}}" title="call"
                                                   class="fas fa-phone-alt"></a>
{{--                                                <a href="{{$relatedAdvertisement->store_id}}" title="chat"--}}
{{--                                                   class="fas fa-comments"></a>--}}
                                                <button type="button" title="whatsapp"
                                                        onclick="location.href='https://api.whatsapp.com/send?phone={{$relatedAdvertisement->shop->phone}}'"
                                                        class="fab fa-whatsapp no-top" tabindex="0"></button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    </div>
                </div>

            </div>
        </section>
    @endif
    <div id="snackbar">{{__('website.link-copied-to-clipboard')}}</div>

@endsection
@section('extra-models')
    <div class="modal fade" id="ad-share">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h4>Share this Ad</h4>
                    <button class="fas fa-times" data-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <div class="modal-share">
                        <a href="https://www.facebook.com/sharer.php?u={{route('website.advertisement-details',['id'=>$advertisement->id,'slug'=>$advertisement->slug,'type'=>$type])}}" target="_blank">
                            <i class="facebook fab fa-facebook-f"></i><span>{{__('website.facebook')}}</span></a>
                        <a href="https://twitter.com/intent/tweet?text={{$advertisement->title}}&url={{route('website.advertisement-details',['id'=>$advertisement->id,'slug'=>$advertisement->slug,'type'=>$type])}}" target="_blank"><i
                                class="twitter fab fa-twitter"></i><span>{{__('website.twitter')}}</span></a>
                        <a href="https://api.whatsapp.com/send/?text={{__('website.chatting-for-text').route('website.advertisement-details',['id'=>$advertisement->id,'slug'=>$advertisement->slug,'type'=>$type])}}&app_absent=0" target="_blank"><i
                                class="whatsapp-social fab fa-whatsapp"></i><span>{{__('website.whats-app')}}</span></a>
                        <a href="javascript:myFunction('{{route('website.advertisement-details',['id'=>$advertisement->id,'slug'=>$advertisement->slug,'type'=>$type])}}');"
                           id="copy-link"><i
                                class="link fas fa-link"></i><span>{{__('website.copy-link')}}</span></a></div>
                </div>
            </div>
        </div>
    </div>
    <div class="modal fade" id="location-share">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h4>Share this Ad</h4>
                    <button class="fas fa-times" data-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <div class="modal-share">
                        <a href="https://www.facebook.com/sharer.php?u=https://maps.google.com/maps/search/?q={{$advertisement->shop->latitude}},{{$advertisement->shop->longitude}}&hl=es&z=14&amp;output=embed" target="_blank"><i
                                class="facebook fab fa-facebook-f"></i><span>facebook</span></a>
                        <a href="https://twitter.com/intent/tweet?text=https://maps.google.com/maps/search/?q={{$advertisement->shop->latitude}},{{$advertisement->shop->longitude}}&hl=es&z=14&amp;output=embed" target="_blank"><i
                                class="twitter fab fa-twitter"></i><span>twitter</span></a>
                        <a href="https://api.whatsapp.com/send?text=https://maps.google.com/maps/search/?q={{$advertisement->shop->latitude}},{{$advertisement->shop->longitude}}&hl=es&z=14&amp;output=embed" target="_blank"><i
                                class="whatsapp-social fab fa-whatsapp"></i><span>whatsapp</span></a>
                        <a href="javascript:myFunction('https://maps.google.com/maps/search/?q={{$advertisement->shop->latitude}},{{$advertisement->shop->longitude}}&hl=es&z=14&amp;output=embed')"><i
                                class="link fas fa-link"></i><span>copy link</span></a></div>
                </div>
            </div>
        </div>
    </div>
    <div class="modal fade" id="report">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h4>{{__('website.report')}}</h4>
                    <button class="fas fa-times" data-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <form class="adpost-form" action="{{route('website.report-advertisement')}}" method="post">
                        @csrf
                        <input type="hidden" name="advertisement_id" value="{{$advertisement->id}}">
                        <input type="hidden" name="type" value="4">
                        <div class="adpost-card">
                            <div class="adpost-title mb-10">
                                <h3>{{__('website.report-this-shop')}}</h3>
                            </div>
                            @if(count($advertisementsReports))
                                <div class="row">
                                    <div class="col-md-12 col-lg-12">
                                        <div class="form-group">
                                            <ul class="form-check-list">
                                                @foreach($advertisementsReports as $advertisementsReport)

                                                    <li class="mb-3">
                                                        <input type="radio" value="{{$advertisementsReport->id}}" name="reason_id" class="form-check"
                                                               id="fix-check{{$advertisementsReport->id}}">
                                                        <label for="fix-check{{$advertisementsReport->id}}"
                                                               class="form-check-text">{{$advertisementsReport->content}}</label>
                                                    </li>
                                                @endforeach

                                            </ul>
                                        </div>
                                    </div>

                                </div>
                            @endif
                            <button type="submit" class="btn btn-inline review-submit">
                                <span>{{__('website.report')}}</span></button>
                        </div>


                    </form>
                </div>
            </div>
        </div>
    </div>
    <div class="modal fade" id="profile-share">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h4>Share this Profile</h4>
                    <button class="fas fa-times" data-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <div class="modal-share"><a
                            href="https://www.facebook.com/sharer.php?u={{route('website.shop-details',['id'=>$advertisement->shop->id,'slug'=>$advertisement->shop->slug])}}" target="_blank"><i
                                class="facebook fab fa-facebook-f"></i><span>facebook</span></a>
                        <a href="https://twitter.com/intent/tweet?text={{route('website.shop-details',['id'=>$advertisement->shop->id,'slug'=>$advertisement->shop->slug])}}" target="_blank"><i
                                class="twitter fab fa-twitter"></i><span>twitter</span></a>
                        <a href="https://api.whatsapp.com/send/?text={{route('website.shop-details',['id'=>$advertisement->shop->id,'slug'=>$advertisement->shop->slug])}}" target="_blank"><i
                                class="whatsapp-social fab fa-whatsapp"></i><span>whatsapp</span></a>
                        <a href="javascript:myFunction('{{route('website.shop-details',['id'=>$advertisement->shop->id,'slug'=>$advertisement->shop->slug])}}')"><i
                                class="link fas fa-link"></i><span>copy link</span></a></div>
                </div>
            </div>
        </div>
    </div>
    <div class="modal fade" id="number">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h4>Contact this Number</h4>
                    <button class="fas fa-times" data-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <h3 class="modal-number"><a
                            href="tel:{{$advertisement->phone?$advertisement->phone:$advertisement->shop->phone}}">{{$advertisement->phone?$advertisement->phone:$advertisement->shop->phone}}</a></h3>
                </div>
            </div>
        </div>
    </div>

    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/font-awesome/4.5.0/css/font-awesome.min.css">
    <a href="https://api.whatsapp.com/send?phone=+{{$advertisement->phone?$advertisement->phone:$advertisement->shop->phone}}&text=Hello%2C+Admin%21%0D%0AI+want+to+contact+you+about+this+ad: {{route('website.advertisement-details',['id'=>$advertisement->id,'slug'=>$advertisement->slug])}}"
       class="float" target="_blank">
        <i class="fa fa-whatsapp top-5 my-float"></i></a>

    <a href="tel:{{$advertisement->phone?$advertisement->phone:$advertisement->shop->phone}}" class="float2"
       target="_blank">
        <i class="fa fa-phone top-5 my-float2"></i></a>

    {{--    <a href="message-details.html" class="float3" target="_blank">--}}
    {{--        <i class="fas fa-comments top-5 my-float3"></i></a>--}}
    <script>
        function myFunction(link) {
            //window.location.href
            navigator.clipboard.writeText(link);
            var x = document.getElementById("snackbar");
            x.className = "show";
            setTimeout(function(){ x.className = x.className.replace("show", ""); }, 3000);

        }


    </script>
@endsection
