@extends('Website.layouts.app',['title'=>$selectedCategory?$selectedCategory->name:__('website.advertisements'),'description'=>$selectedCategory?$selectedCategory->description:__('website.advertisements')])
@section('page-title')
    {{$selectedCategory?__('website.advertisements-title').$selectedCategory->name:__('website.advertisements-title')}}
@endsection
@section('banner')
    <section class="inner-section single-banner">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <div class="single-content">
                        <h1>{{$selectedCategory?$selectedCategory->name:__('website.advertisements')}}</h1>
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="{{route('website.index')}}">{{__('website.home')}}</a>
                            </li>
                            @if($selectedCategory && $selectedCategory->category)
                                <li class="breadcrumb-item active" aria-current="page"><a
                                        href="{{route('website.all-advertisements',['category'=>$selectedCategory && $selectedCategory->category?$selectedCategory->category->slug:'all','type'=>$type])}}">{{$selectedCategory && $selectedCategory->category?$selectedCategory->category->name:__('website.advertisements')}}</a>
                                </li>
                                <li class="breadcrumb-item active"
                                    aria-current="page">{{$selectedCategory?$selectedCategory->name:__('website.advertisements')}}</li>

                            @else
                                <li class="breadcrumb-item active"
                                    aria-current="page">{{$selectedCategory?$selectedCategory->name:__('website.advertisements')}}</li>

                            @endif
                        </ol>
                    </div>
                </div>
            </div>
        </div>
    </section>

@endsection
@section('content')
    <section class="inner-section ad-list-part">
        <div class="container">
            <div class="row content-reverse">
                <div class="col-lg-4 col-xl-3 hidden-small-2">
                    <form action="{{route('website.all-advertisements',['category'=>$category,'type'=>$type])}}"
                          method="Get" id="filter-form" class="sticky">

                    <div class="row sticky mx-h">

                        <input type="hidden" name="view" value="{{$pageView}}">
                        <input type="hidden" name="pages" value="{{$pages}}">
                            @if(count($subCategories)>0)

                                <div class="col-md-6 col-lg-12">
                                    <div class="product-widget">
                                        <h6 class="product-widget-title">{{__('website.filter-by-sub-categories')}}</h6>
                                        <div class="product-widget-form">
                                            <ul class="product-widget-list product-widget-scroll">
                                                @foreach($subCategories as $subCategory)
                                                    <li class="product-widget-item">
                                                        <div class="product-widget-checkbox">
                                                            <input type="checkbox" name="sub_category_id[]"
                                                                   value="{{$subCategory->id}}"
                                                                   @if(request()->sub_category_id&& in_array($subCategory->id,request()->sub_category_id)) checked
                                                                   @endif
                                                                   id="chcek{{$subCategory->id}}">
                                                        </div>
                                                        <label class="product-widget-label"
                                                               for="chcek{{$subCategory->id}}"><span
                                                                class="product-widget-text">{{$subCategory->name}}</span><span
                                                                class="product-widget-number">({{$subCategory->advertisements_count}})</span></label>
                                                    </li>
                                                @endforeach

                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            @endif
                            @if(count($allCities)>0)
                                <div class="col-md-6 col-lg-12">
                                    <div class="product-widget">
                                        <h6 class="product-widget-title">{{__('website.filter-by-cities')}}</h6>
                                        <div class="product-widget-form">
                                            <ul class="product-widget-list product-widget-scroll">
                                                @foreach($allCities as $city)
                                                    <li class="product-widget-item">
                                                        <div class="product-widget-checkbox">
                                                            <input type="checkbox" name="city_id[]"
                                                                   @if(request()->city_id&& in_array($city->id,request()->city_id)) checked
                                                                   @endif value="{{$city->id}}"
                                                                   id="chcek{{$city->id}}">
                                                        </div>
                                                        <label class="product-widget-label"
                                                               for="chcek{{$city->id}}"><span
                                                                class="product-widget-text">{{$city->name}}</span><span
                                                                class="product-widget-number">({{$city->advertisements_count}})</span></label>
                                                    </li>
                                                @endforeach
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            @endif

                            <div class="col-md-6 col-lg-12">
                                <div class="product-widget">
                                    <h6 class="product-widget-title">{{__('website.filter-by-price')}}</h6>
                                    <div class="product-widget-form">
                                        <div class="product-widget-group">
                                            <input type="number" name="min_price"
                                                   value="@if(request()->min_price){{request()->min_price}}@endif"
                                                   min="{{$minPrice}}" placeholder="{{__('website.min')}} - {{$minPrice}}">
                                            <input type="number" name="max_price"
                                                   value="@if(request()->max_price){{request()->max_price}}@endif"
                                                   max="{{$maxPrice}}" placeholder="{{__('website.max')}}  - {{$maxPrice}}">
                                        </div>
                                    </div>

                                </div>
                            </div>
                            <div class="col-md-6 col-lg-12">
                                <div class="product-widget">
                                    <h6 class="product-widget-title">{{__('website.filter-by-type')}}</h6>
                                    <div class="product-widget-form">
                                        <ul class="product-widget-list">
                                            <li class="product-widget-item">
                                                <div class="product-widget-checkbox">
                                                    <input type="checkbox" name="advertisement_type[]" value="2"
                                                           id="checkpremuim"
                                                           @if(request()->advertisement_type&& in_array(2,request()->advertisement_type)) checked @endif>
                                                </div>
                                                <label class="product-widget-label" for="chcek2"><span
                                                        class="product-widget-type rent">{{__('website.premium')}}</span><span
                                                        class="product-widget-number">({{$premiumAds}})</span></label>
                                            </li>

                                            <li class="product-widget-item">
                                                <div class="product-widget-checkbox">
                                                    <input type="checkbox" name="advertisement_type[]" value="3"
                                                           @if(request()->advertisement_type&& in_array(3,request()->advertisement_type)) checked
                                                           @endif id="chcekregular">
                                                </div>
                                                <label class="product-widget-label" for="chcekregular"><span
                                                        class="product-widget-type sale">{{__('website.regular')}}</span><span
                                                        class="product-widget-number">({{$nonPremiumAds}})</span></label>
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                            </div>

                            @if(count($rates)>0)

                                <div class="col-md-6 col-lg-12">
                                    <div class="product-widget">
                                        <h6 class="product-widget-title">{{__('website.filter-by-rating')}}</h6>
                                        <div class="product-widget-form">
                                            <ul class="product-widget-list">
                                                @foreach($rates as $rate=>$advertisementsRate)
                                                    <li class="product-widget-item">
                                                        <div class="product-widget-checkbox">
                                                            <input type="checkbox" id="chcek{{$rate}}" name="rates[]"
                                                                   @if(request()->rates&& in_array($rate,request()->rates)) checked
                                                                   @endif value="{{$rate}}">
                                                        </div>
                                                        <label class="product-widget-label" for="chcek{{$rate}}">
                                                <span class="product-widget-star">
                                                    @for($i=0; $i<$rate; $i++)
                                                        <i class="fas fa-star"></i>
                                                    @endfor
                                                    @for($i=0; $i<(5-$rate); $i++)
                                                        <i class="far fa-star"></i>
                                                    @endfor
                                                </span>
                                                            <span
                                                                class="product-widget-number">({{count($advertisementsRate)}})</span></label>
                                                    </li>
                                                @endforeach
                                            </ul>

                                        </div>
                                    </div>
                                </div>
                            @endif

                            @if(count($properties))
                                @foreach($properties as $property)

                                    <div class="col-md-6 col-lg-12">
                                        <div class="product-widget">
                                            <h6 class="product-widget-title">{{$property->name}}</h6>
                                            <div class="product-widget-form">
                                                <ul class="product-widget-list product-widget-scroll">
                                                    @foreach($property->children as $child )
                                                        <li class="product-widget-item">
                                                            <div class="product-widget-checkbox">
                                                                <input type="checkbox" name="properties[]"
                                                                       @if(request()->properties&& in_array($child->id,request()->properties)) checked
                                                                       @endif
                                                                       value="{{$child->id}}"
                                                                       id="chcek{{$child->id}}">
                                                            </div>
                                                            <label class="product-widget-label"
                                                                   for="chcek{{$child->id}}"><span
                                                                    class="product-widget-text">{{$child->name}}</span><span
                                                                    class="product-widget-number">({{$child->advertisements_count}})</span></label>
                                                        </li>
                                                    @endforeach

                                                </ul>
                                            </div>
                                        </div>
                                    </div>
                                @endforeach
                            @endif

                            <div class="col-md-6 col-lg-12">
                                <div class="product-widget">
                                    <div class="product-widget-form" style="width: 100%;">

                                    </div>
                                </div>
                            </div>



                    </div>
                    </form>
                    <button type="button" onclick="$('#filter-form').submit()" class="btn btn-inline button-sticky ">
                        <i class="fas fa-search"></i>
                        <span>{{__('website.search')}}</span></button>


                </div>
                <div class="col-lg-8 col-xl-9">
                    <div class="row">
                        <div class="col-lg-12">
                            <div class="header-filter">
                                <div class="filter-show"><label class="filter-label">{{__('website.show')}} :</label>
                                    <select
                                        onchange="this.options[this.selectedIndex].value && (window.location = '{{request()->fullUrlWithQuery(['view' => $pageView])}}'+'&pages='+this.options[this.selectedIndex].value);"
                                        class="custom-select filter-select">
                                        <option value="12" @if($pages==12) selected @endif>12</option>
                                        <option value="24" @if($pages==24) selected @endif>24</option>
                                        <option value="36" @if($pages==36) selected @endif>36</option>
                                    </select></div>
                                <button type="button" class="header-widget sidebar-btn2 d-xl-hidden d-md-none"><i
                                        class="fas fa-filter"></i></button>
                                <div class="filter-short"><label class="filter-label">{{__('website.sort-by')}}
                                        :</label>
                                    <select
                                        onchange="this.options[this.selectedIndex].value && (window.location = '{{request()->fullUrlWithQuery(['view' => $pageView])}}'+'&sortBy='+this.options[this.selectedIndex].value);"
                                        class="custom-select filter-select">
                                        <option value="default"
                                                @if($sortBy=='default') selected @endif>{{__('website.default')}}</option>
                                        <option value="rated"
                                                @if($sortBy=='rated') selected @endif>{{__('website.most-rated')}}</option>
                                        <option value="price"
                                                @if($sortBy=='price') selected @endif>{{__('website.price')}}</option>
                                        <option value="date"
                                                @if($sortBy=='date') selected @endif>{{__('website.recent')}}</option>
                                    </select></div>
                                <div class="filter-action">
                                    <a href="{{request()->fullUrlWithQuery(['view' => 4])}}" title="Three Column"
                                       @if($pageView==4)class="active"@endif><i class="fas fa-th"></i></a><a
                                        href="{{request()->fullUrlWithQuery(['view' => 6])}}"
                                        title="Two Column" @if($pageView==6)class="active"@endif><i
                                            class="fas fa-th-large"></i></a><a
                                        href="{{request()->fullUrlWithQuery(['view' => 12])}}" title="One Column"
                                        @if($pageView==12)class="active"@endif><i
                                            class="fas fa-th-list"></i></a></div>
                            </div>
                        </div>
                    </div>
                    @if(count($premiumAdsSlider)>0)

                        <div class="row">
                            <div class="col-lg-12">
                                <div class="ad-feature-slider slider-arrow">
                                    @foreach($premiumAdsSlider as $premiumAd)
                                        <div class="feature-card">
                                            <a href="#" class="feature-img">
                                                <img
                                                    src="{{$premiumAd->image()}}"
                                                    alt="feature"></a>
                                            <div class="cross-inline-badge feature-badge">
                                                <span>@if($premiumAd->is_negotiable==0){{__('website.negotiable')}}@else{{__('website.not-negotiable')}}@endif</span><i
                                                    class="fas fa-book-open"></i></div>
                                            <button type="button"
                                                    onclick="favorite({{$premiumAd->id}})"
                                                    class="feature-wish @if($premiumAd->is_favorite==1) active @endif" id="favorite{{$premiumAd->id}}"><i class="fas fa-heart"></i></button>
                                            <div class="feature-content">
                                                <ol class="breadcrumb feature-category">
                                                    <li><span
                                                            class="flat-badge rent">@if($premiumAd->premium==1){{__('website.premium')}} @else {{__('website.regular')}} @endif</span>
                                                    </li>
                                                    <li class="breadcrumb-item"><a
                                                            href="{{route('website.all-advertisements',['category'=>$premiumAd->subCategory->category->slug,'type'=>'View'])}}">{{$premiumAd->subCategory->category->name}}</a>
                                                    </li>
                                                    <li class="breadcrumb-item active"
                                                        aria-current="page"><a
                                                            href="{{route('website.all-advertisements',['category'=>$premiumAd->subCategory->slug,'type'=>'View'])}}">{{$premiumAd->subCategory->name}}</a>
                                                    </li>
                                                </ol>
                                                <h3 class="feature-title"><a
                                                        href="{{route('website.advertisement-details',['id'=>$premiumAd->id,'slug'=>$premiumAd->slug,'type'=>$type])}}">{{$premiumAd->title}}</a>
                                                </h3>
                                                <div class="feature-meta"><span
                                                        class="feature-price">{{$premiumAd->price}} {{$premiumAd->city->country->currency}}</span><span
                                                        class="feature-time"><i class="fas fa-clock"></i>{{\Carbon\Carbon::createFromTimeStamp(strtotime($premiumAd->created_at))->diffForHumans()}}</span>
                                                </div>
                                            </div>
                                        </div>
                                    @endforeach
                                </div>
                            </div>
                        </div>
                    @endif
                    @if(count($advertisements)>0)
                        <div class="row">

                            @foreach($advertisements as $advertisement)

                                <div
                                    class="col-sm-{{$pageView}} col-md-{{$pageView}} col-lg-{{$pageView}} col-xl-{{$pageView}}">
                                    <div class="product-card  @if($pageView==12) standard @endif">
                                        <div class="product-media">
                                            <a href="{{route('website.advertisement-details',['id'=>$advertisement->id,'slug'=>$advertisement->slug,'type'=>$type])}}"
                                               tabindex="0">
                                                <div class="product-img"><img src="{{$advertisement->image()}}"
                                                                              alt="{{$advertisement->title}}"></div>
                                            </a>
                                            @if($advertisement->premium==0)
                                                <div class="cross-vertical-badge product-badge"><i
                                                        class="fas fa-clipboard-check"></i>
                                                    <span>{{__('website.regular')}}</span>
                                                </div>
                                            @else
                                                <div class="cross-vertical-badge product-badge">
                                                    <i class="fas fa-bolt"></i>
                                                    <span>{{__('website.premium')}}</span>
                                                </div>
                                            @endif
                                            @if($advertisement->is_negotiable==1)
                                                <div class="product-type"><span
                                                        class="flat-badge rent">{{__('website.negotiable')}}</span>
                                                </div>
                                            @else
                                                <div class="product-type"><span
                                                        class="flat-badge sale">{{__('website.not-negotiable')}}</span>
                                                </div>

                                            @endif
                                            <ul class="product-action">
                                                <li class="view"><i
                                                        class="fas fa-eye"></i><span>{{$advertisement->views_count}}</span>
                                                </li>
                                                <li class="click"><i
                                                        class="fas fa-heart"></i><span>{{$advertisement->favorite_count}}</span>
                                                </li>
                                                <li class="rating"><i class="fas fa-star"></i><span>{{$advertisement->average_rate}}/5</span>
                                                </li>
                                            </ul>
                                        </div>
                                        <div class="product-content">
                                            <ol class="breadcrumb product-category">
                                                <li><i class="fas fa-tags"></i></li>
                                                <li class="breadcrumb-item"><a
                                                        href="{{route('website.all-advertisements',['category'=>$advertisement->subCategory->category->slug,'type'=>'View'])}}">{{$advertisement->subCategory->category->name}}</a>
                                                </li>
                                                <li class="breadcrumb-item active" aria-current="page"><a
                                                        href="{{route('website.all-advertisements',['category'=>$advertisement->subCategory->slug,'type'=>'View'])}}">{{$advertisement->subCategory->name}}</a>
                                                </li>
                                            </ol>

                                            <h5 class="product-title"><a
                                                    href="{{route('website.advertisement-details',['id'=>$advertisement->id,'slug'=>$advertisement->slug,'type'=>$type])}}">
                                                    {{$advertisement->title}}
                                                </a></h5>
                                            <div class="product-meta"><span><i class="fas fa-map-marker-alt"></i>
                                                    {{$advertisement->city->country->name}},
                                            {{$advertisement->city->name}}</span><span><i class="fas fa-clock"></i>{{\Carbon\Carbon::createFromTimeStamp(strtotime($advertisement->created_at))->diffForHumans()}}</span>
                                            </div>
                                            <div class="product-info">
                                                <h5 class="product-price">{{$advertisement->price}} {{$advertisement->city->country->currency}}</h5>
                                                <div class="product-btn"><a href="tel:{{$advertisement->phone}}"
                                                                            title="call"
                                                                            class="fas fa-phone-alt"></a>
                                                    {{--                                                    <a href="{{$advertisement->store_id}}" title="chat" class="fas fa-comments"></a>--}}
                                                    <button type="button" title="whatsapp"
                                                            onclick="window.open('https://api.whatsapp.com/send?phone={{$advertisement->phone}}')"
                                                            class="fab fa-whatsapp no-top" tabindex="0"></button>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                            @endforeach
                        </div>
                    @else
                        @include('Website.pages.errors.empty')


                    @endif
                    <div class="row">
                        <div class="col-lg-12">
                            <div class="footer-pagection">
                                <p class="page-info">{{__('website.Showing')}} {{$advertisements->count()}}  {{__('website.of')}}   {{$advertisements->total()}} {{__('website.results')}}</p>
                                {{$advertisements->withQueryString()->appends(['type' => $type])->links()}}
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </section>

@endsection
