@extends('Website.layouts.app')
@section('page-title')
    {{__('website.blogs')}}
@endsection

@section('banner')
    <section class="single-banner">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <div class="single-content">
                        <h1>{{__('website.blog-list')}}</h1>
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="{{route('website.index')}}">{{__('website.home')}}</a>
                            </li>
                            <li class="breadcrumb-item active" aria-current="page">{{__('website.blog-list')}}</li>
                        </ol>
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection
@section('content')
    <section class="blog-part">
        <div class="container">
            <div class="row content-reverse">
                <div class="col-lg-4">
                    <div class="row">
                        <div class="col-md-8 col-lg-12 m-auto">
                            <div class="blog-sidebar">
                                <div class="blog-sidebar-title">
                                    <h5>{{__('website.popular-post')}}</h5>
                                </div>
                                @if(count($popularPosts))
                                <ul class="blog-suggest">
                                    @foreach($popularPosts as $popularPost)
                                    <li>
                                        <div class="suggest-img"><a href="#"><img src="{{$popularPost->image()}}"
                                                                                  alt="blog"></a></div>
                                        <div class="suggest-content">
                                            <div class="suggest-title">
                                                <h4><a href="{{route('website.blog-details',['id'=>$popularPost->id,'slug'=>$popularPost->slug])}}">{{$popularPost->title}}</a></h4>
                                            </div>
                                            <div class="suggest-meta">
                                                <div class="suggest-date"><i class="far fa-calendar-alt"></i>
                                                    <p>{{$popularPost->created_at}}</p>
                                                </div>
{{--                                                <div class="suggest-comment"><i class="far fa-comments"></i>--}}
{{--                                                    <p>{{$popularPost->comments_count}}</p>--}}
{{--                                                </div>--}}
                                            </div>
                                        </div>
                                    </li>
                                    @endforeach

                                </ul>
                                    @endif
                            </div>
                        </div>
                        <div class="col-md-8 col-lg-12 m-auto">
                            <div class="blog-sidebar">
                                <div class="blog-sidebar-title">
                                    <h5>{{__('website.follow-us')}}</h5>
                                </div>
                                <ul class="blog-icon">
                                    @foreach($settings->where('key',\App\Helpers\Constant::SETTING_KEYS['Social media']) as $social)
                                        <li><a href="{{$social->content}}"><i class="fab fa-{{$social->title}}"></i></a></li>
                                    @endforeach
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-lg-8">
                    <div class="row">
                        @if(count($blogs)>0)
                            @foreach($blogs as $blog)
                                <div class="col-sm-10 col-md-6 col-lg-6" style="padding-bottom: 50px;">
                                    <div class="blog-card">
                                        <div class="blog-img"><img src="{{$blog->image()}}" alt="{{$blog->title}}">
                                            <div class="blog-overlay">

                                            </div>
                                        </div>
                                        <div class="blog-content">
                                            <a  class="blog-avatar">
                                                <img src="{{ $blog->author->image ?? defaultMoonImage() }}" alt="{{$blog->author->name}}">
                                            </a>
                                            </a>
                                            <ul class="home-blog">
                                                <li><i class="fas fa-user"></i>
                                                    <p><a>{{$blog->author->name}}</a></p>
                                                </li>
                                                <li><i class="fas fa-clock"></i>
                                                    <p>{{$blog->created_at}}</p>
                                                </li>
                                            </ul>
                                            <div class="blog-text">
                                                <h4><a href="{{route('website.blog-details',['id'=>$blog->id,'slug'=>$blog->slug])}}">{{$blog->title}}</a></h4>
                                                <p>
                                                    ....</p>
                                            </div>
                                            <a href="{{route('website.blog-details',['id'=>$blog->id,'slug'=>$blog->slug])}}" class="blog-read"><span>{{__('website.read-more')}}</span><i
                                                    class="fas fa-long-arrow-alt-right"></i></a>
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        @endif
                    </div>
                    <div class="row">
                        <div class="col-lg-12">
                            {{$blogs->links()}}
{{--                            <ul class="pagination">--}}
{{--                                <li class="page-item"><a class="page-link" href="#"><i--}}
{{--                                            class="fas fa-long-arrow-alt-left"></i></a></li>--}}
{{--                                <li class="page-item"><a class="page-link active" href="#">1</a></li>--}}
{{--                                <li class="page-item"><a class="page-link" href="#">2</a></li>--}}
{{--                                <li class="page-item"><a class="page-link" href="#">3</a></li>--}}
{{--                                <li class="page-item">...</li>--}}
{{--                                <li class="page-item"><a class="page-link" href="#">67</a></li>--}}
{{--                                <li class="page-item"><a class="page-link" href="#"><i--}}
{{--                                            class="fas fa-long-arrow-alt-right"></i></a></li>--}}
{{--                            </ul>--}}
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

@endsection
