@extends('Website.layouts.app')
@section('extra-css')
    <link rel="stylesheet" href="{{app()->getLocale()=='en'?asset('website/css/custom/blog-details.css'):asset('website/css/custom/blog-details-rtl.css')}}">
    <link rel="stylesheet" href="{{app()->getLocale()=='en'?asset('website/css/custom/ad-details.css'):asset('website/css/custom/ad-details-rtl.css')}}">


@endsection
@section('page-title')
    {{__('website.explore')}}
@endsection
@section('meta-deep-link')


    <link rel="icon" href="{{$explore->file()}}" type="image/x-icon">
    <link rel="shortcut icon" href="{{$explore->file()}}" type="image/x-icon">

    <meta property="og:title" content="{{$explore->title}}">
    <meta property="og:type" content="website">
    <meta property="og:url" content="{{Request::fullUrl()}}">
    <meta property="og:site_name" content="{{Request::url()}}">
    <meta property="og:description" content="{{$explore->description}}">
    <meta property="og:image"  itemprop="image" content="{{$explore->file()}}">
    <meta property="og:image:secure_url"  itemprop="image" content="{{$explore->file()}}">
    <meta property="og:image:width" content="400" />
    <meta property="og:image:height" content="300" />
    <meta property="og:image:type" content="image/webp" />
    <meta property="og:image:alt" content="{{$explore->title}}">

    <meta property="og:updated_time" content="1440432930" />

    <meta property="twitter:title" content="{{$explore->title}}">
    <meta property="twitter:card" content="summary_large_image">
    <meta property="twitter:description" content="{{$explore->description}}">
    <meta property="twitter:site" content="@moon">
    <meta property="twitter:creator" content="@moon">
    <meta property="twitter:image" content="{{$explore->file()}}">
    <meta property="twitter:image:alt" content="{{$explore->title}}">
@endsection

@section('banner')
    <section class="single-banner">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <div class="single-content">
                        <h1>{{__('website.explore-details')}}</h1>
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item">
                                <a href="{{route('website.index')}}">{{__('website.home')}}</a>
                            </li>

                            <li class="breadcrumb-item active" aria-current="page">{{__('website.explore-details')}}</li>
                        </ol>
                    </div>
                </div>
            </div>
        </div>
    </section>

@endsection
@section('content')


    <section class="blog-details-part">
    <div class="container">

        <div class="row">
            <div class="col-lg-10 m-auto">
                <div class="dash-header-left ">
                    <div class="dash-avatar dash-avatar2 ad-details-author shop-img ">
                        <a class="mb-2" href="{{route('website.shop-details',['id'=>$explore->store->id,'slug'=>$explore->store->slug])}}"><img class="explore-shop-img" src="{{$explore->store->image()}}" alt="{{$explore->store->name}}"></a></div>
                    <div class="dash-intro">
                        <h4><a href="{{route('website.shop-details',['id'=>$explore->store->id,'slug'=>$explore->store->slug])}}">{{$explore->store->name}}</a></h4>
                    </div>

                </div>


                <div class="blog-details-image mb-3">
                    @if(in_array($explore->hubFiles->extension,$videoExtensions))
                    <video width="100%" controls="">
                        <source src="{{$explore->file()}}" type="video/mp4">

                        Your browser does not support the video tag.
                    </video>
                    @else
                        <img src="{{$explore->file()}}" alt="{{$explore->title}}" class="noshaddow">

                        @endif
                </div>


                <div class="ad-details-action ad-details-action3">
                    <button type="button" id="favorite{{$explore->id}}" onclick="favoriteExplore({{$explore->id}})"  class="wish @if($explore->is_liked==1) active @endif"><i class="fas fa-heart"></i>{{__('website.bookmark')}}</button>
                    <button type="button" data-toggle="modal" data-target="#ad-share{{$explore->id}}">
                        <i class="fas fa-share-alt"></i>
                        {{__('website.share')}}
                    </button>
{{--                    <button class="report-button" type="button" data-toggle="modal" data-target="#report">--}}
{{--                        <i class="fas fa-comments"></i>Comment</button>--}}

                </div>

                <div class="ad-details-meta ad-details-meta2 mt-4">
                    <a   class="click mb-5-mobile "><i class="fas fa-heart
                        "></i><span>( <strong id="favorite-explore-count{{$explore->id}}">{{$explore->likes_count}}</strong> ){{__('website.favorites')}}</span></a>
                    <a  class="rating mb-5-mobile">
                        <i class="fas fa-comments"></i>
                        <span> ( <strong>{{$explore->comments_count}}</strong> ) {{__('website.comments')}}</span>
                    </a>
                    <a  class="view share-number mb-5-mobile"><i class="fas fa-share-alt"></i><span> ( <strong>{{$explore->shares_count}}</strong> ) {{__('website.share')}}</span></a>
                </div>




                <div class="blog-details-comment">
                    <div class="comment-title">
                        <h3>{{__('website.comments')}} ({{$explore->comments_count}})</h3>
                    </div>
                    <div class="" id="review">

                        <div class="ad-details-review">
                            @if(count($explore->comments)>0)

                            <ul class="review-list">
                                @foreach($explore->comments as $comment)
                                <li class="review-item">
                                    <div class="review-user">
                                        <div class="review-head">
                                            <div class="review-profile"><a href="#" class="review-avatar"><img src="{{$comment->user->image()??'/website/images/favicon.png'}}" alt="review"></a>
                                                <div class="review-meta">
                                                    <h6><a >{{$comment->user->name}}</a><span>{{\Carbon\Carbon::createFromTimeStamp(strtotime($comment->created_at))->diffForHumans()}}</span></h6>
                                                    <p class="review-desc">{{$comment->comment}}</p>
                                                </div>
                                            </div>
                                        </div>

                                    </div>
                                </li>
                                @endforeach
                                <a href="comments.html"> <i class="fas fa-comments"></i> {{__('website.show-all-comments')}} </a>
                            </ul>
                            @endif

                            <div class="form-title">
                                <h3>{{__('website.leave-your-comment')}}</h3>
                            </div>
                            <form class="review-form" action="{{route('website.comment.explore',$explore->id)}}" method="post">
                              @csrf
                                <div class="form-group">
                                    <textarea class="form-control" placeholder="{{__('website.comment')}}" name="comment"></textarea>
                                </div><button type="submit" class="btn btn-inline review-submit"><span>{{__('website.write-comment')}}</span></button>
                            </form>
                        </div>
                    </div>
                </div>

            </div>
        </div>
        @if(count($relatedExplores)>0)
            @foreach($relatedExplores as $relatedExplore)
        <div class="row">
            <div class="col-lg-10 m-auto">
                <div class="dash-header-left ">
                    <div class="dash-avatar dash-avatar2 ad-details-author shop-img ">
                        <a class="mb-2" href="{{route('website.shop-details',['id'=>$relatedExplore->store->id,'slug'=>$relatedExplore->store->slug])}}"><img class="explore-shop-img" src="{{$relatedExplore->store->image()}}" alt="{{$relatedExplore->store->name}}"></a></div>
                    <div class="dash-intro">
                        <h4><a href="{{route('website.shop-details',['id'=>$relatedExplore->store->id,'slug'=>$relatedExplore->store->slug])}}">{{$relatedExplore->store->name}}</a></h4>
                    </div>

                </div>


                <div class="blog-details-image mb-3">
                    @if(in_array($relatedExplore->hubFiles->extension,$videoExtensions))
                        <video width="100%" controls="">
                            <source src="{{$relatedExplore->file()}}" type="{{$relatedExplore->hubFiles->extension}}">

                            Your browser does not support the video tag.
                        </video>
                    @else
                        <img src="{{$relatedExplore->file()}}" alt="blog-details" class="noshaddow">

                    @endif
                </div>

                <div class="ad-details-action ad-details-action3">
                    <button type="button" id="favorite{{$relatedExplore->id}}" onclick="favoriteExplore({{$relatedExplore->id}})" class="wish @if($relatedExplore->is_liked==1) active @endif"><i class="fas fa-heart"></i>{{__('website.bookmark')}}</button>
                    <button type="button" data-toggle="modal" data-target="#ad-share{{$relatedExplore->id}}">
                        <i class="fas fa-share-alt"></i>
                        {{__('website.share')}}
                    </button>
{{--                    <button class="report-button" type="button" data-toggle="modal" data-target="#report">--}}
{{--                        <i class="fas fa-comments"></i>Comment</button>--}}

                </div>

                <div class="ad-details-meta ad-details-meta2 mt-4">
                    <a class="click mb-5-mobile"><i class="fas fa-heart
                        "></i><span> ( <strong>{{$relatedExplore->likes_count}}</strong> ) {{__('website.favorites')}}</span></a>
                    <a  class="rating mb-5-mobile">
                        <i class="fas fa-comments"></i><span> ( <strong>{{$relatedExplore->comments_count}}</strong> ) {{__('website.comments')}}</span></a>
                    <a  class="view share-number mb-5-mobile">
                        <i class="fas fa-share-alt"></i><span> ( <strong>{{$relatedExplore->shares_count}}</strong> ) {{__('website.share')}}</span></a>
                </div>





                    <div class="blog-details-comment">
                        <div class="comment-title">
                            <h3>{{__('website.comments')}} ({{$relatedExplore->comments_count}})</h3>
                        </div>
                        <div class="" id="review">

                            <div class="ad-details-review">
                                @if(count($relatedExplore->comments)>0)

                                <ul class="review-list">
                                    @foreach($relatedExplore->comments as $relatedComment)
                                        <li class="review-item">
                                            <div class="review-user">
                                                <div class="review-head">
                                                    <div class="review-profile"><a href="#" class="review-avatar"><img src="{{$relatedComment->user->image()??'/website/images/favicon.png'}}" alt="review"></a>
                                                        <div class="review-meta">
                                                            <h6><a >{{$relatedComment->user->name}}</a> <span> {{\Carbon\Carbon::createFromTimeStamp(strtotime($relatedComment->created_at))->diffForHumans()}} </span></h6>
                                                            <p class="review-desc">{{$relatedComment->comment}}</p>
                                                        </div>
                                                    </div>
                                                </div>

                                            </div>
                                        </li>
                                    @endforeach
                                    <a > <i class="fas fa-comments"></i> {{__('website.show-all-comments')}} </a>
                                </ul>
                                @endif

                                <div class="form-title">
                                    <h3>{{__('website.leave-your-comment')}}</h3>
                                </div>
                                <form class="review-form" action="{{route('website.comment.explore',$relatedExplore->id)}}" method="post">
                                    @csrf
                                    <div class="form-group">
                                        <textarea class="form-control" placeholder="{{__('website.comment')}}" name="comment"></textarea>
                                    </div><button type="submit" class="btn btn-inline review-submit"><span>{{__('website.write-comment')}}</span></button>
                                </form>
                            </div>
                        </div>
                    </div>

            </div>
        </div>
                <div class="modal fade" id="ad-share{{$relatedExplore->id}}" aria-hidden="true" style="display: none;">
                    <div class="modal-dialog modal-dialog-centered">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h4>{{__('website.share-this-explore')}}</h4>
                                <button class="fas fa-times" data-dismiss="modal"></button>
                            </div>
                            <div class="modal-body">
                                <div class="modal-share">
                                    <a href="https://www.facebook.com/sharer.php?u={{route('website.explore-details',$relatedExplore->id)}}" target="_blank">
                                        <i class="facebook fab fa-facebook-f"></i><span>{{__('website.facebook')}}</span></a>
                                    <a href="https://twitter.com/intent/tweet?text={{$relatedExplore->store->name}}&url={{route('website.explore-details',$relatedExplore->id)}}" target="_blank"><i
                                            class="twitter fab fa-twitter"></i><span>{{__('website.twitter')}}</span></a>
                                    <a href="https://api.whatsapp.com/send/?text={{route('website.explore-details',$relatedExplore->id)}}&app_absent=0" target="_blank"><i
                                            class="whatsapp-social fab fa-whatsapp"></i><span>{{__('website.whats-app')}}</span></a>
                                    <a href="javascript:myFunction('{{route('website.explore-details',$relatedExplore->id)}}');"
                                       id="copy-link"><i
                                            class="link fas fa-link"></i><span>{{__('website.copy-link')}}</span></a></div>
                            </div>
                        </div>
                    </div>
                </div>

            @endforeach
            @endif
    </div>
</section>
@endsection
@section('extra-models')
    <div class="modal fade" id="ad-share{{$explore->id}}" aria-hidden="true" style="display: none;">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h4>Share this Ad</h4>
                    <button class="fas fa-times" data-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <div class="modal-share">
                        <a href="https://www.facebook.com/sharer.php?u={{route('website.explore-details',$explore->id)}}" target="_blank">
                            <i class="facebook fab fa-facebook-f"></i><span>{{__('website.facebook')}}</span></a>
                        <a href="https://twitter.com/intent/tweet?text={{$explore->store->name}}&url={{route('website.explore-details',$explore->id)}}" target="_blank"><i
                                class="twitter fab fa-twitter"></i><span>{{__('website.twitter')}}</span></a>
                        <a href="https://api.whatsapp.com/send/?text={{route('website.explore-details',$explore->id)}}&app_absent=0" target="_blank"><i
                                class="whatsapp-social fab fa-whatsapp"></i><span>{{__('website.whats-app')}}</span></a>
                        <a href="javascript:myFunction('{{route('website.explore-details',$explore->id)}}');"
                           id="copy-link"><i
                                class="link fas fa-link"></i><span>{{__('website.copy-link')}}</span></a></div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('extra-js-files')

<script>
    $(document).scroll(function() {
        console.log($(window).scrollTop() +'+'+ $(document).height() + '+' +$(window).height() );
        if($(window).scrollTop() >= $(document).height() - $(window).height()) {
            axios.get("{{route('website.explore-details',$explore->id)}}", {
                params: {
                    page: {{$page}},

                }
            })
                .then(function (response) {
                    alert('hit server');
                    // location.reload();

                })

        }
    });

</script>
<script>
    function myFunction(link) {
        //window.location.href
        navigator.clipboard.writeText(link);
        var x = document.getElementById("snackbar");
        x.className = "show";
        setTimeout(function(){ x.className = x.className.replace("show", ""); }, 3000);

    }


</script>
<script>
    function favoriteExplore(explore_id) {
        let Button = $('#favorite' + explore_id);
        let Count = $('#favorite-explore-count');

        axios.get("{{route('website.favorite.explore')}}", {
            params: {
                explore_id: explore_id,
                type:1

            }
        })
            .then(function (response) {
                var type = response.data.type;
                switch (type) {
                    case 'warning':
                        toastr.warning(response.data.message);
                        break;
                    case 'success':
                        toastr.success(response.data.message);
                        break;
                    case 'error':
                        toastr.error(response.data.message);
                        break;
                }
                if (response.data.favoriteType == 'favorite') {
                    Button.addClass('active');
                    Count.text(parseInt(Count.text()) + 1);
                } else {
                    Button.removeClass('acitve');
                    Count.text(parseInt(Count.text()) - 1);


                }

            })

    }

</script>
@endsection
