@extends('Website.layouts.app')
@section('extra-css')
    <link rel="stylesheet" href="{{asset('website/css/custom/my-ads.css')}}">
    <link rel='stylesheet' href='https://maxcdn.bootstrapcdn.com/font-awesome/4.1.0/css/font-awesome.min.css'>
    <link rel="preload" as="style" href="{{asset('website/css/custom/style-social.css')}}">
    <link rel="stylesheet" href="{{app()->getLocale()=='en'?asset('website/css/custom/ad-details.css'):asset('website/css/custom/ad-details-rtl.css')}}">
@endsection
@section('page-title')
    {{__('website.explores')}}
@endsection


@section('banner')
    <section class="single-banner dashboard-banner mb-5">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <div class="single-content">
                        <h1>{{__('website.explore')}}</h1>
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="{{route('website.index')}}">{{__('website.home')}}</a></li>
                            <li class="breadcrumb-item active" aria-current="page">{{__('website.explore')}}</li>
                        </ol>
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection
@section('content')
    <section class="inner-section ad-list-part mt-5 tab-content current mt-5 " id="tab-2" >
        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-12">
                    <div class="section-center-heading">
                        <h2> <span>{{__('website.moon')}}</span> {{__('website.explore')}} </h2>
                        <p>{{__('website.moon-explore-text')}}

                        </p>
                    </div>
                </div>
            </div>
            <div class="row content-reverse">
                <div class="col-md-12">
                    <div class="container-fluid gallery">

                        @foreach($explores as $explore)
                            @if(in_array($explore->hubFiles->extension,$videoExtensions))

                            <a href="{{route('website.explore-details',$explore->id)}}"  class="big">
                                <img class="video" src="{{asset('website/images/play-button-png-projects-330.png')}}">
                            <video width="100%"  >
                                <source src="{{$explore->file()}}#t=0.1" type="{{$explore->hubFiles->getMimeType}}">

                                Your browser does not support the video tag.
                            </video>
                        </a>
                        @else



                        <a href="{{route('website.explore-details',$explore->id)}}"  class="big">
                            <img src="{{$explore->file()}}"/>
                        </a>
                            @endif
                        @endforeach
                    </div>
                </div>
            </div>
        </div>

    </section>

@endsection
@section('extra-js-files')
    <script>

        $(document).ready(function(){

            $('ul.tabs li').click(function(){
                var tab_id = $(this).attr('data-tab');

                $('ul.tabs li').removeClass('current');
                $('.tab-content').removeClass('current');

                $(this).addClass('current');
                $("#"+tab_id).addClass('current');
            })

        })

    </script>
    <!-- image gallery -->
    <script src='https://cdnjs.cloudflare.com/ajax/libs/lightbox2/2.8.2/js/lightbox-plus-jquery.min.js'></script>
    <script src='https://cdnjs.cloudflare.com/ajax/libs/jquery/3.4.1/jquery.min.js'></script>

@endsection
