@extends('Website.layouts.app')
@section('extra-css')
    <link rel="stylesheet" href="{{asset('website/css/custom/about.css')}}">
@endsection
@section('page-title')
    {{__('website.about')}}
@endsection

@section('banner')
    <section class="single-banner">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <div class="single-content">
                        <h1>{{__('website.about-moon')}}</h1>
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="{{route('website.index')}}">{{__('website.home')}}</a></li>
                            <li class="breadcrumb-item active" aria-current="page">{{__('website.about')}}</li>
                        </ol>
                    </div>
                </div>
            </div>
        </div>
    </section>

@endsection
@section('content')
    <section class="about-part">
        <div class="container">
            <div class="row">
                <div class="col-lg-6">
                    <div class="about-content">
                        <h2> <span class="secondary-color bolder">{{__('website.moon')}}</span> {{$about->title}}</h2>
                        <p> {!! $about->content !!}</p>
                    </div>

                </div>
                <div class="col-lg-6">
                    <div class="row about-image">
                        <div class="col-6 col-lg-6"><img src="{{asset('website/images/about/01.jpg')}}" alt="about"></div>
                        <div class="col-6 col-lg-6"><img src="{{asset('website/images/about/02.jpg')}}" alt="about"></div>
                        <div class="col-6 col-lg-6"><img src="{{asset('website/images/about/03.jpg')}}" alt="about"></div>
                        <div class="col-6 col-lg-6"><img src="{{asset('website/images/about/04.jpg')}}" alt="about"></div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    @if(count($sections))

        <section class="best-part">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <div class="section-center-heading">
                        <h2>{{__('website.how-we-best')}}</h2>
                        <p>{{__('website.how-we-best-text')}}</p>
                    </div>
                </div>
            </div>
            <div class="row">
                @foreach($sections as $section)
                <div class="col-md-6 col-lg-4 col-xl-4">
                    <div class="best-card">
                        <div class="best-icon"><i class="fas fa-check-circle"></i></div>
                        <div class="best-content">
                            <h4>{{$section->title}}</h4>{{$section->content}}
                        </div>
                    </div>
                </div>
                @endforeach
            </div>
        </div>
    </section>
        @endif
    @if(count($team))
    <section class="team-part">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <div class="section-center-heading">
                        <h2>{{__('website.behind-the-moon-team')}}</h2>
                        <p>{{__('website.behind-the-moon-team-description')}}</p>
                    </div>
                </div>
            </div>
            <div class="row">
                @foreach($team as $member)
                <div class="col-sm-6 col-md-4 col-lg-4 col-xl-3">
                    <div class="team-card"><img src="{{getImage($member->image)}}" alt="{{$member->title}}">
                        <h5><a href="javascript:void(0)">{{$member->title}}</a></h5>
                        <p>{{$member->content}}</p>

                    </div>
                </div>
                @endforeach

            </div>
        </div>
    </section>
    @endif
    <section class="counter-part">
        <div class="container">
            <div class="row">
                <div class="col-md-4 col-lg-4">
                    <div class="counter-card">
                        <div class="counter-image"><img src="{{asset('website/images/counter/user.png')}}" alt="user"></div>
                        <div class="counter-content">
                            <h2><span class="counter-number">{{$usersCount}}</span>+</h2>
                            <p>{{__('website.registered-users')}}</p>
                        </div>
                    </div>
                </div>
                <div class="col-md-4 col-lg-4">
                    <div class="counter-card">
                        <div class="counter-image"><img src="{{asset('website/images/counter/ads.png')}}" alt="user"></div>
                        <div class="counter-content">
                            <h2><span class="counter-number">{{$advertisementsCount}}</span>+</h2>
                            <p>{{__('website.number-of-advertisements')}}</p>
                        </div>
                    </div>
                </div>
                <div class="col-md-4 col-lg-4">
                    <div class="counter-card">
                        <div class="counter-image"><img src="{{asset('website/images/counter/review.png')}}" alt="user"></div>
                        <div class="counter-content">
                            <h2><span class="counter-number">{{$viewsCount}}</span>+</h2>
                            <p>{{__('website.number-of-views')}}</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

@endsection
