@extends('Website.layouts.app')
@section('extra-css')
    <link rel="stylesheet" href="{{app()->getLocale()=='en'?asset('website/css/custom/blog-details.css'):asset('website/css/custom/blog-details-rtl.css')}}">
    <link rel="stylesheet" href="{{asset('website/css/custom/about.css')}}">
@endsection
@section('page-title')
    {{__('website.safety-steps')}}
@endsection

@section('banner')
    <section class="single-banner">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <div class="single-content">
                        <h1>{{__('website.about-moon')}}</h1>
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="{{route('website.index')}}">{{__('website.home')}}</a></li>
                            <li class="breadcrumb-item active" aria-current="page">{{__('website.about')}}</li>
                        </ol>
                    </div>
                </div>
            </div>
        </div>
    </section>

@endsection
@section('content')
    <section class="about-part mb-10">
        <div class="container">
            <div class="row">
                <div class="col-lg-6">
                    <div class="about-content">
                        <h2> <span class="secondary-color bolder">{{__('website.moon')}}</span>  {{__('website.safety-steps')}}</h2>
                    </div>
                    <p>
                     {!! $safetySteps->content !!}
                    </p>

                </div>
                <div class="col-lg-6">
                    <div class="row about-image">
                        <div class="col-6 col-lg-6"><img src="{{asset('website/images/about/01.jpg')}}" alt="about"></div>
                        <div class="col-6 col-lg-6"><img src="{{asset('website/images/about/02.jpg')}}" alt="about"></div>
                        <div class="col-6 col-lg-6"><img src="{{asset('website/images/about/03.jpg')}}" alt="about"></div>
                        <div class="col-6 col-lg-6"><img src="{{asset('website/images/about/04.jpg')}}" alt="about"></div>
                    </div>
                </div>
            </div>
        </div>
    </section>



@endsection
